//
//  AuMain.h
//  myNewApp
//
//  Created by 三分一 修 on 2012/09/11.
//
//

#ifndef __myNewApp__AuMain__
#define __myNewApp__AuMain__

#include <iostream>
#include <queue>

//#include "SineWave.h"
#include "PSig.h"

#define AUDIO_BUFFER_SIZE 1024

using namespace psig;

class PAudioOutStream {
public:
    virtual void audioOut(double *output, int size, int channels) = 0;
};

class AuMain {
private:
    unsigned int mSamplingRate;
    float mVolume;
    float mPan;
	
	ofMutex mutex;
	double *mixBuffer;
	std::vector<PAudioOutStream *> audioStreams;
	
    AuMain();
	
    static unsigned int mBufferSize;
	
public:
	static AuMain *getInstance() {
		static AuMain *am = NULL;
		if(am == NULL) {
			mBufferSize = AUDIO_BUFFER_SIZE;
			am = new AuMain();
		}
		return am;
	}

	static unsigned int getBufferSize() {
		return mBufferSize;
	}

	void add(PAudioOutStream *audioStream);
	void remove(PAudioOutStream *audioStream);
	
    void audioOut(float *output, int size, int channels);
    
    float volume() { return mVolume; }
    float pan() { return mPan; }
};

#endif /* defined(__myNewApp__AuMain__) */
