#include "GrButton.h"
#include "debug.h"

GrButton::GrButton(int x, int y, int w, int h) :
	fill(false),
	mx(x),
	my(y),
	mw(w),
	mh(h),
	mr(0),
	mg(200),
	mb(0)
{
	debugf("0x%x\n", (int)this);
}
	
void GrButton::update()
{

}

void GrButton::draw()
{
	double x = mx;
	double y = my;
	double w = mw;
	double h = mh;

	ofPushStyle();
	if(fill) {
		ofFill();
	} else {
		ofNoFill();
	}

	ofSetColor(mr, mg, mb);
	
	ofSetPolyMode(OF_POLY_WINDING_ODD);
	ofBeginShape();
	ofVertex(x, y);
	ofVertex(x, y+h);
	ofVertex(x+w, y+h);
	ofVertex(x+w, y);
	ofVertex(x, y);
	ofEndShape();

	ofPopStyle();
}

//--------------------------------------------------------------
void GrButton::mouseMoved(int x, int y)
{
	if(mx <= x && x <= (mx + mw) &&
		my <= y && y <= (my + mh)) {
		mg = 100;
		mButtonStatus = GR_BUTTON_ENTERED;
	} else {
		mg = 200;
		mButtonStatus = GR_BUTTON_OUT;
	}
}

//--------------------------------------------------------------
void GrButton::mouseDragged(int x, int y, int button)
{
	// dummy for virtual method
}

//--------------------------------------------------------------
void GrButton::mousePressed(int x, int y, int button)
{
	if( mx <= x && x <= (mx + mw) &&
		my <= y && y <= (my + mh)) {
		mButtonStatus = GR_BUTTON_PRESSED;
		for(std::vector<GrButtonListener*>::iterator itr = mButtonListeners.begin();
			itr != mButtonListeners.end(); itr++) {
			((GrButtonListener*)*itr)->buttonNotify(GR_BUTTON_PRESSED, this);
		}
	}
}

//--------------------------------------------------------------
void GrButton::mouseReleased(int x, int y, int button)
{
	if(mButtonStatus == GR_BUTTON_PRESSED) {
		for(std::vector<GrButtonListener*>::iterator itr = mButtonListeners.begin();
			itr != mButtonListeners.end(); itr++) {
			((GrButtonListener*)*itr)->buttonNotify(GR_BUTTON_RELEASED, this);
		}
	}
}

void GrButton::addButtonListener(GrButtonListener *listener)
{
	// TODO Mutex lock / uncok with mouseXXXX()
	mButtonListeners.push_back(listener);
}

void GrButton::removeButtonListener(GrButtonListener *listener)
{
	// TODO Mutex lock / uncok with mouseXXXX()

	vector<GrButtonListener*>::iterator itr = mButtonListeners.begin();

	while(itr != mButtonListeners.end()) {
		debugf("0x%x\n", (int)*itr);
		itr++;
	}
	
	vector<GrButtonListener*>::iterator end_itr = remove(mButtonListeners.begin(),
													mButtonListeners.end(), listener);
	
	mButtonListeners.erase(end_itr, mButtonListeners.end());
}

void GrButton::setColor(int r, int g, int b)
{
	mr = r;
	mg = g;
	mb = b;
}

void GrButton::setColor(const ofColor &c)
{
	mr = c.r;
	mg = c.g;
	mb = c.b;
}
