#ifndef __GR_DIAL__
#define __GR_DIAL__

#include "GrMain.h"
#include "PDraw.h"

class GrDial;

class GrDialListener {
public:
	virtual void dialValueChanged(GrDial *grDial, double value) = 0;
};

enum eGrDialState {
	GR_DIAL_RELEASED = 0,
	GR_DIAL_PRESSED,
};

class GrDial : public GrMouse
{
public:
	GrDial(GrMain *parent, int x, int y, int size);
	virtual ~GrDial();

	virtual void mouseMoved(int x, int y);
	virtual void mouseDragged(int x, int y, int button);
	virtual void mousePressed(int x, int y, int button);
	virtual void mouseReleased(int x, int y, int button);

	void addGrDialListener(GrDialListener *listener);
	void removeGrDialListener(GrDialListener *listener);

private:
	GrMain *parent;
	std::vector<GrDialListener*> mDialListeners;
	eGrDialState mState;
	int mX, mY, mSize;
	int mPressX, mPressY;
	PRotZ *rotz;
	double mValue; // 0 ~ 1.0
	double mDialSpeed;
};

#endif // __GR_DIAL__
