#ifndef __PDRAW__
#define __PDRAW__

#include "GrMain.h"
#include "PSig.h"
#include "PDrawStyle.h"

using namespace psig;

class PDrawer {
public:
	virtual void draw() = 0;
};

/**
 * @brief PDraw class
 * @description super class of P class
 * @note 
 */
class PDraw : public GrDrawer {
public:
PDraw(PDrawer *drawer) : enable(1), impl(drawer) {}

	void addStyle(PDrawStyle *drawStyle) {
		mDrawStyles.push_back(ofPtr<PDrawStyle>(drawStyle));
	}
	
	void draw() {
		double en = enable;

		if(en) {
			ofPushMatrix();
			ofPushStyle();

			for(std::vector<ofPtr<PDrawStyle> >::iterator itr = mDrawStyles.begin(); itr != mDrawStyles.end(); itr++) {
				ofPtr<PDrawStyle> ptr = *itr;
				ptr->drawStyle();
			}

			impl->draw();

			ofPopStyle();
			ofPopMatrix();
		}
	}

	PPort enable;

protected:
	std::vector<ofPtr<PDrawStyle> > mDrawStyles;

private:
	ofPtr<PDrawer> impl;
};

/**
 * @brief PRect class
 * @description Rect class has PPort parameter.
 * @note 
 */
class PRect : public PDrawer {
public:
	PGenConstructor2Arg(PRect, w, h);
	
	virtual ~PRect() {};
	void draw();
	PPort w, h;
};

/**
 * @brief PCircle class
 * @description Circle class has PPort parameter.
 * @note 
 */
class PCircle : public PDrawer {
public:
	PGenConstructor3Arg(PCircle, w, h, num);
	
	virtual ~PCircle() {};
	void draw();
	PPort w, h, num;
};

/**
 * @brief PRing class
 * @description Ring class has PPort parameter.
 * @note 
 */
class PRing : public PDrawer {
public:
	//PRing() {};
	PGenConstructor4Arg(PRing, w, h, weight, num);
	virtual ~PRing() {};
	void draw();
	PPort w, h;
	PPort weight; // ring weight ratio : 0 ~ 1
	PPort num; // num of point
};

/**
 * @brief PRingRect class
 * @description RingRect class has PPort parameter.
 * @note 
 */
class PRingRect : public PDrawer {
public:
	//PRingRect() {};
	PGenConstructor3Arg(PRingRect, w, h, weight);
	virtual ~PRingRect() {};
	void draw();
	PPort w, h;
	PPort weight; // ring weight ratio : 0 ~ 1
};

/**
 * @brief PArc class
 * @description Arc class has PPort parameter.
 * @note 
 */
class PArc : public PDrawer {
public:
	PArc() {};
	virtual ~PArc() {};
	void draw();
	PPort w, h;
	PPort radS, radE;
	PPort num; // num of point
	PPort weight; // ring weight ratio : 0 ~ 1
};

#endif // __PDRAW__
