#include "GrColors.h"
#include "PDrawTest002.h"

PDrawTest002::PDrawTest002(GrMain *gr) :
	parent(gr),
	cnt(0)
{
	AuMain *au = AuMain::getInstance();
	au->add(this);
}

PDrawTest002::~PDrawTest002()
{
	AuMain *au = AuMain::getInstance();
	au->remove(this);
}

/**
 * @brief PDrawTest002
 * @description PDraw Test Class 002
 */
void PDrawTest002::draw() {
	if(cnt == 5) {
		cnt = 0;
		//if(ofRandom(1.0f) > 0.85) {
		// size 
		double size = ofRandom(ofGetHeight() * 0.2, ofGetHeight() * 0.9);

		// color value select
		int colorNumber = ofRandom(COLOR_COOL_4C_DARK_BLUE, COLOR_COOL_4C_PURPLE);
		double alpha = ofRandom(160, 224);

		// life
		int life = ofRandom(20, 40);
		
		PArc *arc = new PArc();
		arc->num = 100 + size * 0.5;
		arc->w = size;
		arc->h = size;
		arc->weight = 0.3;
		arc->radS = ofRandom(0, _PI2);
		arc->radE = ofRandom(0, _PI2);

		PDraw *pdraw = new PDraw(arc);

		pdraw->addStyle(new PPos(ofGetWidth()>>1, ofGetHeight()>>1));
		
		// PRot *rot = new PRot(0.2, 0.5, 0.0);
		// rot->z = new PCntd(0.1, ofRandom(0.2, 0.8), life);
		// pdraw->addStyle(rot);

		{
			PRotY *rot = new PRotY(0.0);
			rot->y = new PCntd(ofRandom(0, 360), ofRandom(100, 200), life);
			pdraw->addStyle(rot);
		}

		{
			PRotZ *rot = new PRotZ(0.0);
			rot->z = new PCntd(20, ofRandom(100, 200), life);
			pdraw->addStyle(rot);
		}

		{
			PColor4 *pcol = new PColor4();
			pcol->r = colorSet[colorNumber].r;
			pcol->g = colorSet[colorNumber].g;
			pcol->b = colorSet[colorNumber].b;
			pcol->a = new PCntd(alpha, 0, life);
			pdraw->addStyle(pcol);
		}
								   
		parent->remove(pdraw, life);

		parent->add(pdraw);
	}

	cnt++;
}

void PDrawTest002::mouseMoved(int x, int y ) {};
void PDrawTest002::mouseDragged(int x, int y, int button) {};
void PDrawTest002::mousePressed(int x, int y, int button) {};
void PDrawTest002::mouseReleased(int x, int y, int button) {};

void PDrawTest002::audioOut(double *output, int size, int channels)
{
	for(int i = 0; i < size; i++) {
		double v = sin.tick();
		for(int k = 0; k < channels; k++) {
			//output[i * channels + k] = v;
			output[i * channels + k] = 0;
		}
	}
}

GrMain *createPDrawTest_002() {
	GrMain* gr = new GrMain();
	gr->add(new PDrawTest002(gr));
	return gr;
}


