/*
 * D2A
 * Copyright (C) SatisKia. All rights reserved.
 */

package net.satis.d2a;

import android.graphics.Bitmap;
import android.os.Build;
import android.view.*;
import android.webkit.*;

public class _WebView extends WebViewClient
{
	private _Main _m;
	private WebView _view;

	public _WebView( _Main m, WebView view )
	{
		_m = m;
		_view = view;
		_view.setWebViewClient( this );
	}

	public void destroy()
	{
		_view.stopLoading();
		_view.setWebViewClient( null );
		_view.destroy();
		_view = null;
	}

	public void suspend()
	{
		try
		{
			WebView.class.getMethod( "onPause" ).invoke( _view );
		}
		catch( Exception e ){}
		_view.pauseTimers();
	}

	public void resume()
	{
		try
		{
			WebView.class.getMethod( "onResume" ).invoke( _view );
		}
		catch( Exception e ){}
		_view.resumeTimers();
	}

	public WebView getView()
	{
		return _view;
	}

	public void addJavascriptInterface( Object object, String name )
	{
		// Android 4.2iAPI level 17jȍ~
		if( Build.VERSION.SDK_INT >= 17 )
		{
			_view.addJavascriptInterface( object, name );
		}
	}
	public void setAppCacheEnabled( boolean enabled )
	{
		_view.getSettings().setAppCacheEnabled( enabled );
	}
	public void setBackgroundColor( int color )
	{
		_view.setBackgroundColor( color );
	}
	public void setBuiltInZoomControls( boolean enabled )
	{
		_view.getSettings().setBuiltInZoomControls( enabled );
	}
	public void setDefaultTextEncodingName( String encoding )
	{
		_view.getSettings().setDefaultTextEncodingName( encoding );
	}
	public void setDomStorageEnabled( boolean enabled )
	{
		_view.getSettings().setDomStorageEnabled( enabled );
	}
	public void setJavaScriptEnabled( boolean enabled )
	{
		_view.getSettings().setJavaScriptEnabled( enabled );
	}
	public String getUserAgentString()
	{
		return _view.getSettings().getUserAgentString();
	}
	public void setUserAgentString( String ua )
	{
		_view.getSettings().setUserAgentString( ua );
	}

	public void clearCache()
	{
		_view.clearCache( true );
	}

	public void loadUrl( String url )
	{
		_view.loadUrl( url );
	}

	public void loadFile( String file )
	{
		_view.loadUrl( "file:///android_asset/" + file );
	}

	public void callScript( String script )
	{
		_view.loadUrl( "javascript:" + script );
	}

	// V URL w肳ꂽƂ̏
	@Override
	public boolean shouldOverrideUrlLoading( WebView view, String url )
	{
		if( _m.onWebViewShouldStartLoad( url ) )
		{
			return true;
		}
		return super.shouldOverrideUrlLoading( view, url );
	}

	// y[Wǂݍ݊Jn̏
	@Override
	public void onPageStarted( WebView view, String url, Bitmap favicon )
	{
		super.onPageStarted( view, url, favicon );
		_m.onWebViewStartLoad( url );
	}

	// y[Wǂݍ݊̏
	@Override
	public void onPageFinished( WebView view, String url )
	{
		super.onPageFinished( view, url );
		_m.onWebViewFinishLoad( url );
	}

	// y[Wǂݍ݃G[̏
	@Override
	public void onReceivedError( WebView view, int errorCode, String description, String failingUrl )
	{
		super.onReceivedError( view, errorCode, description, failingUrl );
		_m.onWebViewLoadError( errorCode, description, failingUrl );
	}

	public void setFocus()
	{
		_view.requestFocus( View.FOCUS_DOWN );
	}

	public boolean canGoForward()
	{
		return _view.canGoForward();
	}
	public void goForward()
	{
		if( canGoForward() )
		{
			_view.goForward();
		}
	}

	public boolean canGoBack()
	{
		return _view.canGoBack();
	}
	public void goBack()
	{
		if( canGoBack() )
		{
			_view.goBack();
		}
	}

	public void zoomIn()
	{
		_view.zoomIn();
	}

	public void zoomOut()
	{
		_view.zoomOut();
	}
}
