##
## D2P
## Copyright (C) SatisKia. All rights reserved.
##

package _Graphics;

use Image::Magick;

BEGIN
{
	$_col = '#000000';
	$_a = 255;
}

sub new
{
	my $pkg = shift;
	$_font = shift;
	bless [], $pkg;
}

sub setColor
{
	shift;
	my $r = shift;
	my $g = shift;
	my $b = shift;
	$_col = sprintf( "#%02X%02X%02X", $r, $g, $b );
}

sub setAlpha
{
	shift;
	$_a = shift;
}

sub setFont
{
	shift;
	$_size = shift;
}

sub lock
{
	shift;
	$_file = shift;
	$_w = shift;
	$_h = shift;
	$_canvas = Image::Magick->new;
	$_canvas->Set( size => $_w . 'x' . $_h );
	$_canvas->ReadImage( 'xc:none' );
}

sub unlock
{
	$_canvas->Write( $_file );
}

sub createImage
{
	shift;
	my $file = shift;
	my $src = Image::Magick->new;
	$src->ReadImage( $file );
	return $src;
}

sub drawImage
{
	shift;
	my $src = shift;
	my $x = shift;
	my $y = shift;
	$src = $src->Fx( expression => 'a/(255/' . $_a . ')', channel => 'alpha' );
	$_canvas->Composite(
		image => $src,
		geometry => '+' . $x . '+' . $y,
		compose => 'over'
		);
}

sub drawScaledImage
{
	shift;
	my $src = shift;
	my $x = shift;
	my $y = shift;
	my $w = shift;
	my $h = shift;
	$src = $src->Fx( expression => 'a/(255/' . $_a . ')', channel => 'alpha' );
	$src->Resize( width => $w, height => $h );
	$_canvas->Composite(
		image => $src,
		geometry => '+' . $x . '+' . $y,
		compose => 'over'
		);
}

sub drawLine
{
	shift;
	my $x0 = shift;
	my $y0 = shift;
	my $x1 = shift;
	my $y1 = shift;
	my $src = Image::Magick->new;
	$src->Set( size => $_w . 'x' . $_h );
	$src->ReadImage( 'xc:none' );
	$src->Draw(
		primitive => 'line',
		points => $x0 . ',' . $y0 . ' ' . $x1 . ',' . $y1,
		stroke => $_col,
		strokewidth => 0
		);
	$src = $src->Fx( expression => 'a/(255/' . $_a . ')', channel => 'alpha' );
	$_canvas->Composite(
		image => $src,
		geometry => '+0+0',
		compose => 'over'
		);
}

sub drawRect
{
	shift;
	my $x = shift;
	my $y = shift;
	my $w = shift;
	my $h = shift;
	$_canvas->Draw(
		primitive => 'rectangle',
		points => $x . ',' . $y . ' ' . ($x + $w) . ',' . ($y + $h),
		stroke => $_col . sprintf( "%02X", $_a ),
		fill => 'none'
		);
}

sub fillRect
{
	shift;
	my $x = shift;
	my $y = shift;
	my $w = shift;
	my $h = shift;
	$_canvas->Draw(
		primitive => 'rectangle',
		points => $x . ',' . $y . ' ' . ($x + $w - 1) . ',' . ($y + $h - 1),
		stroke => 'none',
		fill => $_col . sprintf( "%02X", $_a )
		);
}

sub drawString
{
	shift;
	my $str = shift;
	my $x = shift;
	my $y = shift;
	$_canvas->Annotate(
		text => $str,
		geometry => '+' . $x . '+' . $y,
		font => $_font,
		pointsize => $_size,
		fill => $_col
		);
}

1;
