/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.strings;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import jdd.des.automata.Automata;
import jdd.des.automata.AutomataIO;
import jdd.des.automata.Automaton;
import jdd.des.automata.Event;
import jdd.des.automata.EventManager;
import jdd.des.automata.State;
import jdd.des.automata.Transition;
import jdd.des.strings.AlphabetNodeNames;
import jdd.des.strings.ZDDStrings;
import jdd.util.Array;

public class AutomataSublanguage {
    private ZDDStrings zdd;
    private Automata automata;
    private EventManager em;
    private int events;
    private Vector to_add = new Vector();
    private HashSet workset = new HashSet(64);

    public AutomataSublanguage(Automata automata) {
        this.automata = automata;
        this.em = automata.getEventManager();
        this.events = this.em.getSize();
        this.zdd = new ZDDStrings(this.events);
        this.zdd.setBound(automata.maxNumOfLocalStates());
        this.zdd.setNodeNames(new AlphabetNodeNames(this.em));
        Event event = this.em.head();
        int n = 0;
        while (event != null) {
            event.extra1 = this.zdd.getEvent(n++);
            event = event.next;
        }
        Enumeration enumeration = this.automata.elements();
        while (enumeration.hasMoreElements()) {
            Automaton automaton = (Automaton)enumeration.nextElement();
            this.calc_language(automaton);
        }
    }

    private void calc_language(Automaton automaton) {
        int n;
        int n2 = n = automaton.numOfNodes();
        int n3 = 0;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n4 = 0;
        this.workset.clear();
        Enumeration enumeration = automaton.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            State state = (State)enumeration.nextElement();
            state.extra1 = n4;
            if (state.isInitial()) {
                nArray[n4] = 1;
                this.workset.add(state);
            } else {
                nArray[n4] = 0;
            }
            ++n4;
        }
        for (n4 = 0; n4 < n2; ++n4) {
            Array.set(nArray2, 0);
            this.to_add.removeAllElements();
            for (State state : this.workset) {
                Transition transition = (Transition)state.firstOut;
                while (transition != null) {
                    State state2 = (State)transition.n2;
                    if (nArray[state2.extra1] == 0) {
                        this.to_add.add(state2);
                    }
                    int n5 = this.zdd.ref(this.zdd.concat(nArray[state.extra1], transition.event.parent.extra1));
                    int n6 = this.zdd.ref(this.zdd.union(nArray2[state2.extra1], n5));
                    this.zdd.deref(n5);
                    this.zdd.deref(nArray2[state2.extra1]);
                    nArray2[state2.extra1] = n6;
                    transition = (Transition)transition.next;
                }
            }
            for (int i = 0; i < n; ++i) {
                if (nArray2[i] == 0) continue;
                int n7 = this.zdd.ref(this.zdd.union(nArray2[i], nArray[i]));
                this.zdd.deref(nArray2[i]);
                this.zdd.deref(nArray[i]);
                nArray[i] = n7;
            }
            enumeration = this.to_add.elements();
            while (enumeration.hasMoreElements()) {
                this.workset.add(enumeration.nextElement());
            }
        }
        for (n4 = 0; n4 < n; ++n4) {
            int n8 = this.zdd.ref(this.zdd.union(n3, nArray[n4]));
            this.zdd.deref(n3);
            this.zdd.deref(nArray[n4]);
            n3 = n8;
        }
        this.zdd.printSet(n3);
        System.out.println("|L| = " + this.zdd.count(n3) + ", nodes = " + this.zdd.nodeCount(n3) + ", top = " + this.zdd.top(n3));
        automaton.extra3 = n3;
    }

    public static void main(String[] stringArray) {
        Automata automata = AutomataIO.loadXML("data/phil.xml");
        AutomataSublanguage automataSublanguage = new AutomataSublanguage(automata);
    }
}

