/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.strings;

import jdd.des.strings.SimpleAlphabetNodeNames;
import jdd.util.JDDConsole;
import jdd.util.Test;
import jdd.zdd.ZDD;

public class ZDDStrings
extends ZDD {
    private int num_events;
    private int concat_bottom;
    private int concat_offset;
    private boolean[] sigma1;
    private boolean[] sigma2;

    ZDDStrings(int n) {
        super(10000, 1000);
        this.num_events = n;
        this.setNodeNames(new SimpleAlphabetNodeNames(n));
    }

    public int getEpsilon() {
        return 1;
    }

    public int getEmptySet() {
        return 0;
    }

    public int getEvent(int n) {
        Test.check(n >= 0 && n < this.num_events);
        return this.change(1, n);
    }

    public void setBound(int n) {
        while (n * this.num_events > this.num_vars) {
            this.createVar();
        }
    }

    public int top(int n) {
        if (n < 2) {
            return 0;
        }
        return 1 + this.getVar(n) / this.num_events;
    }

    public int concat(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (n == 1) {
            return n2;
        }
        if (n2 == 1) {
            return n;
        }
        this.concat_bottom = n2;
        this.concat_offset = (1 + this.getVar(n2) / this.num_events) * this.num_events;
        return this.concat_rec(n);
    }

    private int concat_rec(int n) {
        if (n < 2) {
            return n == 0 ? 0 : this.concat_bottom;
        }
        int n2 = this.concat_rec(this.getLow(n));
        this.work_stack[this.work_stack_tos++] = n2;
        int n3 = n2;
        int n4 = this.concat_rec(this.getHigh(n));
        this.work_stack[this.work_stack_tos++] = n4;
        int n5 = n4;
        int n6 = this.mk(this.getVar(n) + this.concat_offset, n3, n5);
        this.work_stack_tos -= 2;
        return n6;
    }

    public int reduce(int n) {
        int n2;
        if (n < 2) {
            return n;
        }
        int n3 = this.reduce(this.getLow(n));
        this.work_stack[this.work_stack_tos++] = n3;
        int n4 = n3;
        int n5 = this.reduce(this.getHigh(n));
        this.work_stack[this.work_stack_tos++] = n5;
        int n6 = n5;
        int n7 = Math.max(this.getVar(n4), this.getVar(n6));
        for (n2 = this.getVar(n); n7 + this.num_events < n2; n2 -= this.num_events) {
        }
        int n8 = this.mk(n2, n4, n6);
        this.work_stack_tos -= 2;
        return n8;
    }

    public int expand(int n) {
        if (n < 2) {
            return n;
        }
        int n2 = this.expand(this.getLow(n));
        this.work_stack[this.work_stack_tos++] = n2;
        int n3 = n2;
        int n4 = this.expand(this.getHigh(n));
        this.work_stack[this.work_stack_tos++] = n4;
        int n5 = n4;
        int n6 = Math.max(this.getVar(n3), this.getVar(n5));
        int n7 = n6 == -1 ? n6 : n6 / this.num_events;
        int n8 = this.getVar(n);
        while (n7 >= n8 / this.num_events) {
            n8 += this.num_events;
        }
        int n9 = this.mk(n8, n3, n5);
        this.work_stack_tos -= 2;
        return n9;
    }

    public int close(int n) {
        if (n < 2) {
            return n;
        }
        int n2 = this.close(this.getHigh(n));
        this.work_stack[this.work_stack_tos++] = n2;
        int n3 = n2;
        int n4 = this.getLow(n) == 0 ? this.getHigh(n) : this.close(this.getLow(n));
        this.work_stack[this.work_stack_tos++] = n4;
        int n5 = n4;
        int n6 = this.mk(this.getVar(n), n5, n3);
        this.work_stack_tos -= 2;
        return n6;
    }

    public final int compose(int n, int n2, boolean[] blArray, boolean[] blArray2) {
        this.sigma1 = blArray;
        this.sigma2 = blArray2;
        return this.compose_rec(n, n2);
    }

    private final int compose_rec(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (n2 == n) {
            return n;
        }
        if (n == 1) {
            return this.follow_low(n2);
        }
        if (n2 == 1) {
            return this.follow_low(n);
        }
        int n3 = this.getVar(n) % this.num_events;
        int n4 = this.getVar(n2) % this.num_events;
        if (!this.sigma1[n4] && !this.sigma2[n3]) {
            int n5 = this.concat(n, this.change(1, n4));
            this.work_stack[this.work_stack_tos++] = n5;
            int n6 = n5;
            int n7 = this.union(n, n6);
            this.work_stack[this.work_stack_tos++] = n7;
            int n8 = n7;
            --this.work_stack_tos;
            int n9 = this.concat(n2, this.change(1, n3));
            this.work_stack[this.work_stack_tos++] = n9;
            n6 = n9;
            int n10 = this.union(n2, n6);
            this.work_stack[this.work_stack_tos++] = n10;
            int n11 = n10;
            this.work_stack_tos -= 3;
            this.work_stack[this.work_stack_tos++] = n11;
            this.work_stack[this.work_stack_tos++] = n8;
            JDDConsole.out.print("*q was: ");
            this.printSet(n2);
            JDDConsole.out.print("*p was: ");
            this.printSet(n);
            JDDConsole.out.print("*q is : ");
            this.printSet(n8);
            JDDConsole.out.print("*p is : ");
            this.printSet(n11);
            n6 = this.compose_rec(n8, n11);
            this.work_stack_tos -= 2;
            JDDConsole.out.print("* ret : ");
            this.printSet(n6);
            return n6;
        }
        JDDConsole.out.print("q was: ");
        this.printSet(n2);
        JDDConsole.out.print("p was: ");
        this.printSet(n);
        int n12 = this.sigma1[n4] ? n : this.concat(n, this.change(1, n4));
        this.work_stack[this.work_stack_tos++] = n12;
        n = n12;
        int n13 = this.sigma2[n3] ? n2 : this.concat(n2, this.change(1, n3));
        this.work_stack[this.work_stack_tos++] = n13;
        n2 = n13;
        JDDConsole.out.print("q is: ");
        this.printSet(n2);
        JDDConsole.out.print("p is: ");
        this.printSet(n);
        JDDConsole.out.println("\n");
        int n14 = 0;
        if (this.getVar(n) > this.getVar(n2)) {
            n14 = this.compose_rec(this.getLow(n), n2);
        } else if (this.getVar(n) < this.getVar(n2)) {
            n14 = this.compose_rec(n, this.getLow(n2));
        } else {
            int n15 = this.compose_rec(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n15;
            n14 = n15;
            int n16 = this.compose_rec(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n16;
            int n17 = n16;
            n14 = this.mk(this.getVar(n), n14, n17);
            this.work_stack_tos -= 2;
        }
        this.work_stack_tos -= 2;
        return n14;
    }

    public static void main(String[] stringArray) {
    }
}

