package batch.status;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.List;

/**
 * ジョブ詳細管理テーブル取得／更新
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface JobDetailStatus {

	/**
	 * ジョブ詳細管理状態取得
	 *
	 * @param conn コネクション
	 * @param seq ジョブ連番
	 * @param dseq バッチ連番
	 * @return ジョブ詳細管理状態リスト
	 */
	JobDetail getJobDetail(Connection conn, long seq, int dseq);

	/**
	 * ジョブ詳細管理状態取得
	 *
	 * @param conn コネクション
	 * @param seq ジョブ連番
	 * @return ジョブ詳細管理状態リスト
	 */
	List<JobDetail> selectJobDetails(Connection conn, long seq);

	/**
	 * ジョブ詳細管理更新
	 *
	 * @param conn コネクション
	 * @param seq ジョブ連番
	 * @param dseq バッチ連番
	 * @param msg メッセージ
	 * @param status ステータス
	 * @param time 日時
	 * @return 更新レコード数
	 */
	int updateJobDetail(Connection conn, long seq, int dseq,
			String msg, JobState status, Timestamp time);

	/**
	 * ジョブ詳細管理新規作成
	 *
	 * @param conn コネクション
	 * @param seq ジョブ連番
	 * @param pid プロセスID
	 * @param name バッチ処理名称
	 * @param time 日時
	 * @return バッチシーケンス番号
	 */
	int insertJobDetail(Connection conn, long seq, int pid, String name, Timestamp time);

	/**
	 * ジョブ詳細管理削除
	 *
	 * @param conn コネクション
	 * @param seq ジョブ連番
	 * @return 削除件数
	 */
	int deleteJobDetail(Connection conn, long seq);
}
