package batch.status;

import java.io.Serializable;

/**
 * ジョブマスタ情報
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public class JobMaster implements Serializable {
	/** serialVersionUID */
	private static final long serialVersionUID = 1852268153083812353L;

	/** identifier field */
	private String jobId;

	/** persistent field */
	private int multiplicity;

	/** persistent field */
	private String cancelType;

	/** nullable persistent field */
	private String runnableBeginHhmm;

	/** nullable persistent field */
	private String runnableEndHhmm;

	/**
	 * 中止タイプ取得
	 *
	 * @return 中止タイプ
	 */
	public String getCancelType() {
		return this.cancelType;
	}

	/**
	 * 中止タイプ設定
	 *
	 * @param val 中止タイプ
	 */
	public void setCancelType(final String val) {
		this.cancelType = val;
	}

	/**
	 * 実行可能終了時刻取得
	 *
	 * @return 実行可能終了時刻
	 */
	public String getRunnableEnd() {
		return this.runnableEndHhmm;
	}

	/**
	 * 実行可能終了時刻設定
	 *
	 * @param val 実行可能終了時刻
	 */
	public void setRunnableEnd(final String val) {
		this.runnableEndHhmm = val;
	}

	/**
	 * 実行多重度取得
	 *
	 * @return 実行多重度
	 */
	public int getMultiplicity() {
		return this.multiplicity;
	}

	/**
	 * 実行多重度設定
	 *
	 * @param val 実行多重度
	 */
	public void setMultiplicity(final int val) {
		this.multiplicity = val;
	}

	/**
	 * ジョブID取得
	 *
	 * @return ジョブID
	 */
	public String getJobId() {
		return this.jobId;
	}

	/**
	 * ジョブID設定
	 *
	 * @param val ジョブID
	 */
	public void setJobId(final String val) {
		this.jobId = val;
	}

	/**
	 * 処理可能開始時刻取得
	 *
	 * @return 処理可能開始時刻
	 */
	public String getRunnableBegin() {
		return this.runnableBeginHhmm;
	}

	/**
	 * 処理可能開始時刻設定
	 *
	 * @param val 処理可能開始時刻
	 */
	public void setRunnableBegin(final String val) {
		this.runnableBeginHhmm = val;
	}
}
