package online.view.model;

import java.io.Serializable;
import java.util.Map;

import javax.servlet.ServletResponse;

/**
 * 表示用マップ
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface ViewMap extends Map<String, Serializable>, Serializable {

	/** 配列オブジェクト アトリビュート名 */
	String ATTR_ARRAY = "array";
	/** 非サニタイズオブジェクト アトリビュート名 */
	String ATTR_UNSANI = "noescape";

	/**
	 * マップ設定
	 *
	 * @param map マップ
	 */
	void setMap(Map<String, Serializable> map);

	/**
	 * マップ取得
	 * @return マップ
	 */
	Map<String, Serializable> getMap();

	/**
	 * レスポンス設定
	 *
	 * @param response レスポンス
	 */
	void setResponse(ServletResponse response);
}
