package online.view.tag;

import javax.servlet.jsp.JspException;

import online.view.ViewUtil;

/**
 * 項目設定タグ
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public class SetTag extends BaseTag {
	/** serialVersionUID */
	private static final long serialVersionUID = -4243257696548973975L;

	/** 保存変数名 */
	private String var = null;
	/** 項目名 */
	private String name = null;
	/** 設定対象用変数 */
	private Object value = null;

	/**
	 * リリース処理
	 */
	@Override
	public void release() {
		this.var = null;
		this.name = null;
		this.value = null;
	}

	/**
	 * 変数設定
	 *
	 * @param val 保存変数名文字列
	 */
	public void setVar(final String val) {
		this.var = val;
	}

	/**
	 * 項目名設定
	 *
	 * @param val 項目名
	 */
	public void setName(final String val) {
		this.name = val;
	}

	/**
	 * 設定対象項目設定
	 *
	 * @param val 選択確認対象文字列
	 */
	public void setValue(final Object val) {
		this.value = val;
	}

	/**
	 * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
	 */
	@Override
	public int doStartTag() throws JspException {
		try {
			if (this.var != null) {
				this.pageContext.removeAttribute(this.var);
			}
			if (this.name != null) {
				super.output(this.var, ViewUtil.getObject(super.getViewMap(), this.name));
			} else if (this.value != null) {
				super.output(this.var, this.value);
			}
			return SKIP_BODY;
		} finally {
			release();
		}
	}
}
