package project.check.existence;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

import core.util.bean.Pair;
import online.context.check.ItemCheck;
import online.model.ModelUtil;
import project.check.BaseCheck;

/**
 * 選択項目配列内妥当性チェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class ElementCheck extends BaseCheck implements ItemCheck {

	/** 項目チェック対象配列 */
	private final String[] array;
	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 * @param s 項目チェック対象配列
	 */
	public ElementCheck(final String[] s) {
		this.array = super.copyOf(s, new String[0]);
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param s 項目チェック対象配列
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public ElementCheck(final String[] s, final String msgId, final String... param) {
		this.array = super.copyOf(s, new String[0]);
		this.mid = msgId;
		this.prm = super.copyOf(param);
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {
		Optional<Pair<String, Integer>> check = Optional.empty();
		for (final String item : items) {
			final String[] val = super.getArrayParameter(item);
			for (int j = 0; val != null && j < val.length; j++) {
				if (!super.isTarget(j)) {
					val[j] = ModelUtil.getValueAsString(super.getUniModel(), item, j);
				} else if (Objects.toString(val[j], "").isEmpty()) {
					continue;
				} else if (!Stream.of(this.array).anyMatch(Predicate.isEqual(val[j]))) {
					super.setMessage(item, j, this.mid, this.prm);
					check = Optional.of(check.orElse(new Pair<>(item, Integer.valueOf(j))));
				}
			}
		}

		check.ifPresent(this::throwKeepCheckException);
	}
}
