package core.util;

import java.math.BigDecimal;

import org.junit.Assert;
import org.junit.Test;

/**
 * TestNumberUtil
 *
 */
public class TestNumberUtil {

	/**
	 * 数値オブジェクトBigDecimal変換
	 */
	@Test
	public void toNumberTest1() {
		Assert.assertEquals(new BigDecimal("123"), NumberUtil.toNumber("123", BigDecimal.class));
	}

	/**
	 * 数値オブジェクトInteger変換
	 */
	@Test
	public void toNumberTest2() {
		Assert.assertEquals(Integer.valueOf("1234"), NumberUtil.toNumber("1,234", Integer.class));
	}

	/**
	 * 数値オブジェクトInteger変換不可
	 */
	@Test
	public void toNumberTest3() {
		Assert.assertNull(NumberUtil.toNumber("123AB", Integer.class));
	}

	/**
	 * 数値オブジェクト掛算nullONE
	 */
	@Test
	public void multiplyTest1() {
		Assert.assertEquals(BigDecimal.ONE, NumberUtil.multiply(null, BigDecimal.ONE));
	}

	/**
	 * 数値オブジェクト掛算ONEnull
	 */
	@Test
	public void multiplyTest2() {
		Assert.assertEquals(BigDecimal.ONE, NumberUtil.multiply(BigDecimal.ONE, null));
	}

	/**
	 * 数値オブジェクト掛算nullnull
	 */
	@Test
	public void multiplyTest3() {
		Assert.assertNull(NumberUtil.multiply(null, null));
	}

	/**
	 * 数値オブジェクト掛算nullnullZERO
	 */
	@Test
	public void multiplyTest4() {
		Assert.assertEquals(BigDecimal.ZERO, NumberUtil.multiply(null, null, BigDecimal.ZERO));
	}

	/**
	 * 数値オブジェクト掛算onenullTEN
	 */
	@Test
	public void multiplyTest5() {
		Assert.assertEquals(BigDecimal.TEN,
				NumberUtil.multiply(BigDecimal.ONE, null, BigDecimal.TEN));
	}
}
