package online.model;

import java.util.Date;

import org.junit.Assert;
import org.junit.Test;

/**
 * TestModelUtilDate
 *
 */
public class TestModelUtilDate {

	/**
	 * Bean->UniModel設定 Date 空
	 */
	@Test
	public void setBeanItemValueTest1() {
		final JavaBean bean = new JavaBean();
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "Date");
		ModelUtil.setBeanItemValue(um, bean, "DateArray");

		Assert.assertTrue(um.containsKey("Date"));
		Assert.assertFalse(um.hasValue("Date"));
		Assert.assertNull(um.getDate("Date"));
		Assert.assertEquals(0, um.getArraySize("Date"));
		Assert.assertEquals(0, um.getDateArray("Date").length);
		Assert.assertFalse(um.isArrayValue("Date"));

		Assert.assertTrue(um.containsKey("DateArray"));
		Assert.assertFalse(um.hasValue("DateArray"));
		Assert.assertNull(um.getDate("DateArray"));
		Assert.assertEquals(0, um.getArraySize("DateArray"));
		Assert.assertEquals(0, um.getDateArray("DateArray").length);
		Assert.assertTrue(um.isArrayValue("DateArray"));
	}

	/**
	 * Bean->UniModel設定 Date 配列
	 */
	@Test
	public void setBeanItemValueTest2() {
		final Date now = new Date();
		final JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "Date");
		ModelUtil.setBeanItemValue(um, bean, "DateArray");

		Assert.assertTrue(um.containsKey("Date"));
		Assert.assertTrue(um.hasValue("Date"));
		Assert.assertEquals(now, um.getDate("Date"));
		Assert.assertEquals(1, um.getArraySize("Date"));
		Assert.assertEquals(1, um.getDateArray("Date").length);
		Assert.assertFalse(um.isArrayValue("Date"));

		Assert.assertTrue(um.containsKey("DateArray"));
		Assert.assertTrue(um.hasValue("DateArray"));
		Assert.assertEquals(now, um.getDate("DateArray"));
		Assert.assertEquals(1, um.getArraySize("DateArray"));
		Assert.assertEquals(1, um.getDateArray("DateArray").length);
		Assert.assertTrue(um.isArrayValue("DateArray"));
	}


	/**
	 * Bean->UniModel追加 Date Date配列 空
	 */
	@Test
	public void addBeanItemValueTest1() {
		final JavaBean bean = new JavaBean();
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "Date");
		ModelUtil.addBeanItemValue(um, bean, "DateArray");

		Assert.assertTrue(um.containsKey("Date"));
		Assert.assertTrue(um.hasValue("Date"));
		Assert.assertNull(um.getDate("Date"));
		Assert.assertEquals(1, um.getArraySize("Date"));
		Assert.assertEquals(1, um.getDateArray("Date").length);
		Assert.assertFalse(um.isArrayValue("Date"));

		Assert.assertTrue(um.containsKey("DateArray"));
		Assert.assertTrue(um.hasValue("DateArray"));
		Assert.assertNull(um.getDateArray("DateArray")[0]);
		Assert.assertEquals(1, um.getArraySize("DateArray"));
		Assert.assertEquals(1, um.getDateArray("DateArray").length);
		Assert.assertTrue(um.isArrayValue("DateArray"));
	}

	/**
	 * Bean->UniModel追加 Date Date配列
	 */
	@Test
	public void addBeanItemValueTest2() {
		final Date now = new Date();
		final JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "Date");
		ModelUtil.addBeanItemValue(um, bean, "DateArray");

		Assert.assertTrue(um.containsKey("Date"));
		Assert.assertTrue(um.hasValue("Date"));
		Assert.assertEquals(now, um.getDate("Date"));
		Assert.assertEquals(1, um.getArraySize("Date"));
		Assert.assertEquals(1, um.getDateArray("Date").length);
		Assert.assertFalse(um.isArrayValue("Date"));

		Assert.assertTrue(um.containsKey("DateArray"));
		Assert.assertTrue(um.hasValue("DateArray"));
		Assert.assertEquals(now, um.getDateArray("DateArray")[0]);
		Assert.assertEquals(1, um.getArraySize("DateArray"));
		Assert.assertEquals(1, um.getDateArray("DateArray").length);
		Assert.assertTrue(um.isArrayValue("DateArray"));
	}

	/**
	 * UniModel→Bean設定 空
	 */
	@Test
	public void setModelValueTest1() {
		final UniModelImpl um = new UniModelImpl();

		final JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um);

		Assert.assertNull(bean.getDate());
		Assert.assertNull(bean.getDateArray());
	}

	/**
	 * UniModel→Bean設定 Date Date配列
	 */
	@Test
	public void setModelValueTest2() {
		final Date now = new Date();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("Date", now);
		um.setValue("DateArray", new Date[]{now});

		final JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals(now, bean.getDate());
		Assert.assertEquals(now, bean.getDateArray()[0]);
	}

	/**
	 * UniModel→Bean設定 DateからBoolean
	 */
	@Test
	public void setModelValueTest3() {
		final Date now1 = new Date();
		final Date now2 = new Date();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveBooleanArray", new Date[]{now1, now2});
		um.setValue("BooleanArray", new Date[]{now1, now2});

		final JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um);

		Assert.assertFalse(bean.isPrimitiveBooleanArray()[0]);
		Assert.assertFalse(bean.isPrimitiveBooleanArray()[1]);
		Assert.assertNull(bean.isBooleanArray()[0]);
		Assert.assertNull(bean.isBooleanArray()[1]);
	}

	/**
	 * UniModel→Bean DateからInteger
	 */
	@Test
	public void setModelValueTest4() {
		final Date now1 = new Date();
		final Date now2 = new Date();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveIntegerArray", new Date[]{now1, now2});
		um.setValue("IntegerArray", new Date[]{now1, now2});

		final JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals(0, bean.getPrimitiveIntegerArray()[0]);
		Assert.assertEquals(0, bean.getPrimitiveIntegerArray()[1]);
		Assert.assertNull(bean.getIntegerArray()[0]);
		Assert.assertNull(bean.getIntegerArray()[1]);
	}

	/**
	 * UniModel→Bean設定 Date null
	 */
	@Test
	public void setModelValueTest5() {
		final Date now = new Date();

		final JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});

		final UniModelImpl um = new UniModelImpl();
		um.setValue("Date", (Date)null);
		um.setValue("DateArray", (Date[])null);
		ModelUtil.setModelValue(bean, um);

		Assert.assertNull(bean.getDate());
		Assert.assertNotNull(bean.getDateArray());
		Assert.assertEquals(0, bean.getDateArray().length);
	}

	/**
	 * UniModel→Bean設定 Date null 空配列
	 */
	@Test
	public void setModelValueTest6() {
		final Date now = new Date();

		final JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});

		final UniModelImpl um = new UniModelImpl();
		um.setValue("Date", (Date)null);
		um.setValue("DateArray", new Date[0]);
		ModelUtil.setModelValue(bean, um);

		Assert.assertNull(bean.getDate());
		Assert.assertNotNull(bean.getDateArray());
		Assert.assertEquals(0, bean.getDateArray().length);
	}


	/**
	 * UniModel→Bean設定 Date 配列添字１
	 */
	@Test
	public void setModelValueTest10() {
		final JavaBean bean = new JavaBean();
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getDate());
		Assert.assertNull(bean.getDateArray());
	}

	/**
	 * UniModel→Bean設定 Date 配列添字１
	 */
	@Test
	public void setModelValueTest11() {
		final Date now = new Date();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("Date", new Date[]{null, now});

		final JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertEquals(now, bean.getDate());
	}

	/**
	 * UniModel→Bean設定 Date 配列添字１ Boolean
	 */
	@Test
	public void setModelValueTest12() {
		final Date now1 = new Date();
		final Date now2 = new Date();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveBoolean", new Date[]{now1, now2});
		um.setValue("Boolean", new Date[]{now1, now2});

		final JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.isPrimitiveBooleanArray());
		Assert.assertNull(bean.isBooleanArray());
		Assert.assertFalse(bean.isPrimitiveBoolean());
		Assert.assertNull(bean.isBoolean());
	}

	/**
	 * UniModel→Bean設定 Date 配列添字１ Integer
	 */
	@Test
	public void setModelValueTest13() {
		final Date now1 = new Date();
		final Date now2 = new Date();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveInteger", new Date[]{now1, now2});
		um.setValue("Integer", new Date[]{now1, now2});

		final JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getPrimitiveIntegerArray());
		Assert.assertNull(bean.getIntegerArray());
		Assert.assertEquals(0, bean.getPrimitiveInteger());
		Assert.assertNull(bean.getInteger());
	}

	/**
	 * UniModel→Bean設定 Date 配列添字１
	 */
	@Test
	public void setModelValueTest15() {
		final Date now = new Date();

		final JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});

		final UniModelImpl um = new UniModelImpl();
		um.setValue("Date", (Date)null);
		um.setValue("DateArray", (Date[])null);
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getDate());
		Assert.assertNotNull(bean.getDateArray());
		Assert.assertEquals(0, bean.getDateArray().length);
	}

	/**
	 * UniModel→Bean設定 Date 配列添字１
	 */
	@Test
	public void setModelValueTest16() {
		final Date now = new Date();

		final JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});

		final UniModelImpl um = new UniModelImpl();
		um.setValue("Date", (Date)null);
		um.setValue("DateArray", new Date[0]);
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getDate());
		Assert.assertNotNull(bean.getDateArray());
		Assert.assertEquals(0, bean.getDateArray().length);
	}


	/**
	 * UniModel→Bean設定 Date
	 */
	@Test
	public void setModelValueTest20() {
		final Date now = new Date();

		final JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});

		final UniModelImpl um = new UniModelImpl();
		um.noValue("Date");
		um.noValue("DateArray");
		ModelUtil.setModelValue(bean, um);

		Assert.assertNull(bean.getDate());
		Assert.assertNull(bean.getDateArray());
	}

	/**
	 * UniModel→Bean設定 Date
	 */
	@Test
	public void setModelValueTest21() {
		final Date now = new Date();

		final JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});

		final UniModelImpl um = new UniModelImpl();
		um.noValue("Date");
		um.noValue("DateArray");

		ModelUtil.setModelValue(bean, um, 0);

		Assert.assertNull(bean.getDate());
		Assert.assertNull(bean.getDateArray());

		bean.setDate(now);
		bean.setDateArray(new Date[]{now});
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getDate());
		Assert.assertNull(bean.getStringArray());
	}


	/**
	 * UniModel→Bean設定 Date
	 */
	@Test
	public void setModelValueTest31() {
		final Date now1 = new Date();
		final Date now2 = new Date();

		final JavaBean bean = new JavaBean();
		bean.setString("String");
		bean.setStringArray(new String[]{"String"});

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", new Date[]{now1, now2});
		um.setValue("StringArray", new Date[]{now2, now2});

		ModelUtil.setModelValue(bean, um, 2);

		Assert.assertEquals("String", bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(2, bean.getStringArray().length);
		Assert.assertEquals(now1.toString(), bean.getStringArray()[0]);
		Assert.assertEquals(now2.toString(), bean.getStringArray()[1]);
	}
}
