package online.jpa.transaction;

import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.persistence.EntityManager;

/**
 * JdbcTransactionInterceptor
 *
 * @author Tadashi Nakayama
 */
@Interceptor
@Dependent
@JdbcTransactional
public class JdbcTransactionInterceptor {

    /**
     * invoke entry
     *
     * @param ic InvocationContext
     * @return Object
     * @throws Exception Exception
     */
    @AroundInvoke
    public Object invoke(final InvocationContext ic) throws Exception {
        final Instance<EntityManager> e = CDI.current().select(EntityManager.class);
        final EntityManager em = e.get();
        try {
            em.getTransaction().begin();
            return ic.proceed();
        } catch (final Throwable ex) {
            em.getTransaction().setRollbackOnly();
            throw ex;
        } finally {
            if (em.getTransaction().isActive()) {
                if (em.getTransaction().getRollbackOnly()) {
                    em.getTransaction().rollback();
                } else {
                    em.getTransaction().commit();
                }
            }
        }
    }
}
