/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.chain2.testutils;

import org.apache.commons.chain2.Context;
import org.apache.commons.chain2.Filter;

/**
 * <p>Implementation of {@link Filter} that logs its identifier and
 * and throws an Exception.</p>
 *
 * @version $Id$
 */
public class ExceptionFilter
        extends ExceptionCommand implements Filter<String, Object, Context<String, Object>> {


    // -------------------------------------------------------------- Properties

    /** id2 */
    private String id2 = null;

    // ------------------------------------------------------------- Constructor

    /**
     * constructor
     */
    public ExceptionFilter() {
        this("", "");
    }


    /**
     * Construct an instance that will log the specified identifier
     * @param val1 String
     * @param val2 String
     */
    public ExceptionFilter(final String val1, final String val2) {
        super(val1);
        this.id2 = val2;
    }

    /**
     * @return String
     */
    public final String getId2() {
        return this.id2;
    }

    /**
     * @param val String
     */
    public final void setId2(final String val) {
        this.id2 = val;
    }


    // --------------------------------------------------------- Command Methods

    /**
     * Postprocess command for this Filter
     * @param context Context
     * @param exception Exception
     * @return boolean
     */
    @Override
    public boolean postprocess(final Context<String, Object> context, final Exception exception) {
        log(context, this.id2);
        return false;
    }

}
