package org.apache.commons.chain2.testutils;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

import org.apache.commons.chain2.Catalog;
import org.apache.commons.chain2.Command;
import org.apache.commons.chain2.Context;
import org.apache.commons.chain2.config.ConfigUtil;

/**
 * @version $Id$
 * @param <K> K
 * @param <V> V
 * @param <C> C
 */
public class TestCatalog<K, V, C extends Context<K, V>> implements Catalog<K, V, C> {

    /** Commands */
    private Map<String, Command<K, V, C>> commands = new HashMap<>();

    /**
     * @see org.apache.commons.chain2.Catalog#addCommand(
     * java.lang.String, org.apache.commons.chain2.Command)
     */
    @Override
    public <T extends Command<K, V, C>> void addCommand(final String name, final T command) {
        this.commands.put(name, command);
    }

    /**
     * @see org.apache.commons.chain2.Catalog#getCommand(java.lang.String)
     */
    @Override
    public <T extends Command<K, V, C>> T getCommand(final String name) {
        return ConfigUtil.cast(this.commands.get(name));
    }

    /**
     * @see org.apache.commons.chain2.Catalog#getNames()
     */
    @Override
    public Stream<String> getNames() {
        return this.commands.keySet().stream();
    }

}
