/*
 * $Id: TestActionMessage.java 471754 2006-11-06 14:55:09Z husted $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.struts.action;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 * Unit tests for the <code>org.apache.struts.action.ActionMessage</code>
 * class.
 *
 * @version $Rev: 471754 $ $Date: 2005-05-19 23:50:06 -0400 (Thu, 19 May 2005)
 *          $
 */
public class TestActionMessage {

    /** amWithNoValue */
    private ActionMessage amWithNoValue = null;
    /** amWithOneValue */
    private ActionMessage amWithOneValue = null;
    /** amWithTwoValues */
    private ActionMessage amWithTwoValues = null;
    /** amWithThreeValues */
    private ActionMessage amWithThreeValues = null;
    /** amWithFourValues */
    private ActionMessage amWithFourValues = null;
    /** amWithArrayValues */
    private ActionMessage amWithArrayValues = null;
    /** amWithTwoIntegerValues */
    private ActionMessage amWithTwoIntegerValues = null;
    /** amNoResource */
    private ActionMessage amNoResource = null;
    /** testValues */
    private Object[] testValues = new Object[] {
        "stringValue1", "stringValue2", "stringValue3", "stringValue4"
    };

    /**
     * setUp
     */
    @Before
    public void setUp() {
        this.amWithNoValue = new ActionMessage("amWithNoValue");
        this.amWithOneValue = new ActionMessage("amWithOneValue", "stringValue");
        this.amWithTwoValues = new ActionMessage("amWithTwoValues", "stringValue1",
                "stringValue2");
        this.amWithThreeValues = new ActionMessage("amWithThreeValues", "stringValue1",
                "stringValue2", "stringValue3");
        this.amWithFourValues = new ActionMessage("amWithFourValues", "stringValue1",
                "stringValue2", "stringValue3", "stringValue4");
        this.amWithArrayValues = new ActionMessage("amWithArrayValues", this.testValues);
        this.amWithTwoIntegerValues =
            new ActionMessage("amWithTwoIntegerValues", Integer.valueOf(5),
                Integer.valueOf(10));
        this.amNoResource = new ActionMessage("amNoResource", false);
    }

    /**
     * tearDown
     */
    @After
    public void tearDown() {
        this.amWithNoValue = null;
        this.amWithOneValue = null;
        this.amWithTwoValues = null;
        this.amWithThreeValues = null;
        this.amWithFourValues = null;
        this.amWithArrayValues = null;
        this.amWithTwoIntegerValues = null;
        this.amNoResource = null;
    }

    /**
     * testActionMessageWithNoValue
     */
    @Test
    public void testActionMessageWithNoValue() {
        Assert.assertTrue(this.amWithNoValue.getValues().length == 0);
        Assert.assertTrue(this.amWithNoValue.isResource());
        Assert.assertEquals(this.amWithNoValue.getKey(), "amWithNoValue");
        Assert.assertEquals("amWithNoValue[]", this.amWithNoValue.toString());
    }

    /**
     * testActionMessageWithAStringValue this.
     */
    @Test
    public void testActionMessageWithAStringValue() {
        Object[] values = this.amWithOneValue.getValues();

        Assert.assertNotNull(values);
        Assert.assertTrue(values.length == 1);
        Assert.assertTrue(values[0].equals("stringValue"));
        Assert.assertTrue(this.amWithOneValue.isResource());
        Assert.assertEquals(this.amWithOneValue.getKey(), "amWithOneValue");
        Assert.assertEquals("amWithOneValue[stringValue]", this.amWithOneValue.toString());
    }

    /**
     * testActionMessageWithTwoValues
     */
    public void testActionMessageWithTwoValues() {
        Object[] values = this.amWithTwoValues.getValues();

        Assert.assertNotNull(values);
        Assert.assertTrue(values.length == 2);
        Assert.assertTrue(values[0].equals("stringValue1"));
        Assert.assertTrue(values[1].equals("stringValue2"));
        Assert.assertTrue(this.amWithTwoValues.isResource());
        Assert.assertEquals(this.amWithTwoValues.getKey(), "amWithTwoValues");
        Assert.assertTrue(this.amWithTwoValues.toString().equals(
                "amWithTwoValues[stringValue1, stringValue2]"));
    }

    /**
     * testActionMessageWithThreeValues
     */
    @Test
    public void testActionMessageWithThreeValues() {
        Object[] values = this.amWithThreeValues.getValues();

        Assert.assertNotNull(values);
        Assert.assertTrue(values.length == 3);
        Assert.assertTrue(values[0].equals("stringValue1"));
        Assert.assertTrue(values[1].equals("stringValue2"));
        Assert.assertTrue(values[2].equals("stringValue3"));
        Assert.assertEquals(this.amWithThreeValues.getKey(), "amWithThreeValues");
        Assert.assertTrue(this.amWithThreeValues.isResource());
        Assert.assertEquals(this.amWithThreeValues.toString(),
                "amWithThreeValues[stringValue1, stringValue2, stringValue3]");
    }

    /**
     * testActionMessageWithFourValues
     */
    public void testActionMessageWithFourValues() {
        Object[] values = this.amWithFourValues.getValues();

        Assert.assertNotNull(values);
        Assert.assertTrue(values.length == 4);
        Assert.assertTrue(values[0].equals("stringValue1"));
        Assert.assertTrue(values[1].equals("stringValue2"));
        Assert.assertTrue(values[2].equals("stringValue3"));
        Assert.assertTrue(values[3].equals("stringValue4"));
        Assert.assertTrue(this.amWithFourValues.isResource());
        Assert.assertEquals(this.amWithFourValues.getKey(), "amWithFourValues");
        Assert.assertEquals(this.amWithFourValues.toString(),
                "amWithFourValues[stringValue1, stringValue2, stringValue3, stringValue4]");
    }

    /**
     * testActionMessageWithArrayValues
     */
    @Test
    public void testActionMessageWithArrayValues() {
        Object[] values = this.amWithArrayValues.getValues();

        Assert.assertNotNull(values);
        Assert.assertEquals(values.length, this.testValues.length);

        for (int i = 0; i < values.length; i++) {
            Assert.assertEquals(values[i], this.testValues[i]);
        }

        Assert.assertTrue(this.amWithArrayValues.isResource());
        Assert.assertEquals(this.amWithArrayValues.getKey(), "amWithArrayValues");
        Assert.assertEquals(this.amWithArrayValues.toString(),
                "amWithArrayValues[stringValue1, stringValue2, stringValue3, stringValue4]");
    }

    /**
     * testActionWithTwoIntegers
     */
    @Test
    public void testActionWithTwoIntegers() {
        Object[] values = this.amWithTwoIntegerValues.getValues();

        Assert.assertNotNull(values);
        Assert.assertTrue(values.length == 2);
        Assert.assertTrue(values[0] instanceof Integer);
        Assert.assertEquals("5", values[0].toString());
        Assert.assertTrue(values[1] instanceof Integer);
        Assert.assertEquals("10", values[1].toString());
        Assert.assertTrue(this.amWithTwoIntegerValues.isResource());
        Assert.assertEquals(this.amWithTwoIntegerValues.getKey(), "amWithTwoIntegerValues");
        Assert.assertEquals(this.amWithTwoIntegerValues.toString(),
                "amWithTwoIntegerValues[5, 10]");
    }

    /**
     * testActionNoResource
     */
    @Test
    public void testActionNoResource() {
        Assert.assertTrue(this.amNoResource.getValues().length == 0);
        Assert.assertFalse(this.amNoResource.isResource());
        Assert.assertEquals(this.amNoResource.getKey(), "amNoResource");
        Assert.assertEquals(this.amNoResource.toString(), "amNoResource[]");
    }
}
