/*
 * $Id: TestActionMessages.java 471754 2006-11-06 14:55:09Z husted $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.struts.action;

import java.util.Iterator;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;


/**
 * Unit tests for the <code>org.apache.struts.action.ActionMessages</code>
 * class.
 *
 * @version $Rev: 471754 $ $Date: 2004-10-16 12:09:25 -0400 (Sat, 16 Oct 2004)
 *          $
 */
public class TestActionMessages {

    /** aMsgs */
    private ActionMessages aMsgs = null;
    /** msg1 */
    private ActionMessage msg1 = null;
    /** msg2 */
    private ActionMessage msg2 = null;
    /** msg3 */
    private ActionMessage msg3 = null;
    /** msg4 */
    private ActionMessage msg4 = null;
    /** msg5 */
    private ActionMessage msg5 = null;

    /**
     * setUp
     */
    @Before
    public void setUp() {
        this.aMsgs = new ActionMessages();

        Object[] objs1 = new Object[] {"a", "b", "c", "d", "e"};
        Object[] objs2 = new Object[] {"f", "g", "h", "i", "j"};

        this.msg1 = new ActionMessage("aMessage", objs1);
        this.msg2 = new ActionMessage("anMessage", objs2);
        this.msg3 = new ActionMessage("msg3", "value1");
        this.msg4 = new ActionMessage("msg4", "value2");
        this.msg5 = new ActionMessage("msg5", "value3", "value4");
    }

    /**
     * tearDown
     */
    @After
    public void tearDown() {
        this.aMsgs = null;
    }

    /**
     * testEmpty
     */
    @Test
    public void testEmpty() {
        Assert.assertTrue("aMsgs is not empty!", this.aMsgs.isEmpty());
    }

    /**
     * testNotEmpty
     */
    @Test
    public void testNotEmpty() {
        this.aMsgs.add("myProp", this.msg1);
        Assert.assertTrue("aMsgs is empty!", !this.aMsgs.isEmpty());
    }

    /**
     * testSizeWithOneProperty
     */
    @Test
    public void testSizeWithOneProperty() {
        this.aMsgs.add("myProp", this.msg1);
        this.aMsgs.add("myProp", this.msg2);
        Assert.assertTrue("number of mesages is not 2", this.aMsgs.size("myProp") == 2);
    }

    /**
     * testSizeWithManyProperties
     */
    @Test
    public void testSizeWithManyProperties() {
        this.aMsgs.add("myProp1", this.msg1);
        this.aMsgs.add("myProp2", this.msg2);
        this.aMsgs.add("myProp3", this.msg3);
        this.aMsgs.add("myProp3", this.msg4);
        this.aMsgs.add("myProp4", this.msg5);
        Assert.assertTrue("number of messages for myProp1 is not 1",
                this.aMsgs.size("myProp1") == 1);
        Assert.assertTrue("number of messages", this.aMsgs.size() == 5);
    }

    /**
     * testSizeAndEmptyAfterClear
     */
    @Test
    public void testSizeAndEmptyAfterClear() {
        testSizeWithOneProperty();
        this.aMsgs.clear();
        testEmpty();
        Assert.assertTrue("number of meesages is not 0", this.aMsgs.size("myProp") == 0);
    }

    /**
     * testGetWithNoProperty
     */
    @Test
    public void testGetWithNoProperty() {
        Iterator<ActionMessage> it = this.aMsgs.get("myProp");
        Assert.assertTrue("iterator is not empty!", !it.hasNext());
    }

    /**
     * testGetForAProperty
     */
    @Test
    public void testGetForAProperty() {
        testSizeWithOneProperty();

        Iterator<ActionMessage> it = this.aMsgs.get("myProp");

        Assert.assertTrue("iterator is empty!", it.hasNext());
    }

    /**
     * Tests adding an ActionMessages object to an ActionMessages object.
     */
    @Test
    public void testAddMessages() {
        ActionMessage m1 = new ActionMessage("key");
        ActionMessage m2 = new ActionMessage("key2");
        ActionMessage m3 = new ActionMessage("key3");
        ActionMessages msgs = new ActionMessages();
        ActionMessages add = new ActionMessages();

        msgs.add("prop1", m1);
        add.add("prop1", m2);
        add.add("prop3", m3);

        msgs.add(add);
        Assert.assertTrue(msgs.size() == 3);
        Assert.assertTrue(msgs.size("prop1") == 2);

        // test message order
        Iterator<ActionMessage> props = msgs.get();
        int count = 1;

        while (props.hasNext()) {
            ActionMessage msg = props.next();

            if (count == 1) {
                Assert.assertEquals("key", msg.getKey());
            } else if (count == 2) {
                Assert.assertEquals("key2", msg.getKey());
            } else {
                Assert.assertEquals("key3", msg.getKey());
            }

            count++;
        }
    }
}
