/*
 * $Id: TestPerformForward.java 481833 2006-12-03 17:32:52Z niallp $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.struts.chain.commands.servlet;

import java.util.HashMap;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.WebMock;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.chain.contexts.ServletActionContext;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.mock.MockPrincipal;
import org.apache.struts.mock.MockServletConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

/**
 * JUnitTest case for class: org.apache.struts.chain.commands.servlet.PerformForward
 */
public class TestPerformForward {

    /** HttpServletRequest */
    private HttpServletRequest request = null;
    /** Pfincipal */
    private MockPrincipal principal = null;
    /** ServletActionContext */
    private ServletActionContext saContext = null;
    /** PerformForward */
    private PerformForward command = null;

    /**
     * setUp method for test case
     */
    @Before
    public void setUp() {
        this.principal = new MockPrincipal("Mr. Macri", new String[] {"administrator"});

        this.request = WebMock.createHttpServletRequest(
                WebMock.createHttpSession(), new HashMap<>(), new HashMap<>());
        Mockito.when(this.request.getUserPrincipal()).thenReturn(this.principal);
        Mockito.when(Boolean.valueOf(this.request.isUserInRole(ArgumentMatchers.anyString()))).
            thenAnswer(m -> {
                return Boolean.valueOf(this.principal.isUserInRole(m.getArgument(0)));
            });

        MockServletConfig servletConfig = new MockServletConfig();
        ServletContext servletContext = WebMock.createServletContext();

        ActionServlet servlet = Mockito.mock(ActionServlet.class);
        Mockito.when(servlet.getServletContext()).thenReturn(servletContext);
        Mockito.when(servlet.getServletConfig()).thenReturn(servletConfig);
        Mockito.when(servlet.getInternal()).thenCallRealMethod();

        HttpServletResponse response = Mockito.mock(HttpServletResponse.class);
        this.saContext = new ServletActionContext(servletContext, this.request, response);

        this.saContext.setActionServlet(servlet);
        this.command = new PerformForward();
    }

    /**
     */
    @Test
    public void testNullForwardPath() {

        ForwardConfig config = new ForwardConfig();
        config.setPath(null);

        try {
            this.command.perform(this.saContext, config);
            Assert.fail("Didn't throw an illegal argument exception on null forward path");
        } catch (final IllegalArgumentException ex) {
            System.out.println("exception: " + ex.getMessage());
            // Do nothing, the test passed
        }
    }
}
