package common.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * DB検索要求
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface SelectQuery {
	/**
	 * クエリ作成
	 *
	 * @return クエリ文字列
	 */
	String makeQuery();

	/**
	 * クエリパラメタ作成
	 *
	 * @return 可変パラメタリスト
	 */
	Map<String, Object> makeParam();

	/**
	 * レコード取得コールバック
	 *
	 * @param rs レザルトセット
	 * @return レコードが存在した場合 true を返す。
	 * @throws SQLException SQL例外
	 */
	boolean callback(ResultSet rs) throws SQLException;
}
