package core.exception;


/**
 * システム例外
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public class PhysicalException extends RuntimeException {
	/** serialVersionUID */
	private static final long serialVersionUID = 1L;

	/**
	 * コンストラクタ
	 *
	 * @param th 原因例外
	 */
	public PhysicalException(final Throwable th) {
		super(filter(th));
	}

	/**
	 * コンストラクタ
	 *
	 * @param message メッセージ
	 * @param th 原因例外
	 */
	public PhysicalException(final String message, final Throwable th) {
		super(message, filter(th));
	}

	/**
	 * フィルタ処理
	 *
	 * @param th 例外
	 * @return フィルタ処理後例外
	 */
	private static Throwable filter(final Throwable th) {
		Throwable t = th;
		while (PhysicalException.class.isInstance(t) && t.getCause() != null) {
			t = t.getCause();
		}
		return t;
	}
}
