package core.util;

/**
 * Booleanユーティリティ
 * @author Tadashi Nakayama
 */
public final class BooleanUtil {

	/**
	 * コンストラクタ
	 */
	private BooleanUtil() {
		throw new AssertionError();
	}

	/**
	 * フラグ値化
	 * @param val 真偽値
	 * @return 真の場合 "1" 偽の場合 "0" を返す。
	 */
	public static String toFlag(final boolean val) {
		return val ? "1" : "0";
	}

	/**
	 * boolean化
	 * @param flag フラグ文字
	 * @return フラグ文字が "1" の場合 true を返す。
	 */
	public static boolean toBool(final String flag) {
		return "1".equals(flag);
	}

	/**
	 * Boolean化
	 * @param flag フラグ文字
	 * @return フラグ文字が "1" の場合 true を返す。
	 */
	public static Boolean toBoolean(final String flag) {
		return Boolean.valueOf(toBool(flag));
	}
}
