package online.view.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

import javax.servlet.ServletResponse;

/**
 * 表示用マップ実装
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public class ViewMapImpl implements ViewMap {
	/** serialVersionUID */
	private static final long serialVersionUID = 1L;

	/** サニタイズ処理項目 */
	private final ViewMap sanitary = new SingleMap(new SanitaryMap());
	/** 非サニタイズ処理項目 */
	private final ViewMap unsanitary = new SingleMap(new UnsanitaryMap());

	/**
	 * マップ設定
	 *
	 * @param val マップオブジェクト
	 */
	@Override
	public void setMap(final Map<String, Serializable> val) {
		this.sanitary.setMap(val);
		this.unsanitary.setMap(val);
	}

	/**
	 * マップ取得
	 */
	@Override
	public Map<String, Serializable> getMap() {
		return this.sanitary.getMap();
	}

	/**
	 * レスポンス設定
	 *
	 * @param val レスポンス
	 */
	@Override
	public void setResponse(final ServletResponse val) {
		this.sanitary.setResponse(val);
		this.unsanitary.setResponse(val);
	}

	/**
	 * @see java.util.Map#size()
	 */
	@Override
	public int size() {
		return this.sanitary.size();
	}

	/**
	 * @see java.util.Map#clear()
	 */
	@Override
	public void clear() {
		throw new UnsupportedOperationException();
	}

	/**
	 * @see java.util.Map#isEmpty()
	 */
	@Override
	public boolean isEmpty() {
		return this.sanitary.isEmpty();
	}

	/**
	 * @see java.util.Map#containsKey(java.lang.Object)
	 */
	@Override
	public boolean containsKey(final Object key) {
		return this.sanitary.containsKey(String.class.cast(key));
	}

	/**
	 * @see java.util.Map#containsValue(java.lang.Object)
	 */
	@Override
	public boolean containsValue(final Object value) {
		throw new UnsupportedOperationException();
	}

	/**
	 * @see java.util.Map#values()
	 */
	@Override
	public Collection<Serializable> values() {
		throw new UnsupportedOperationException();
	}

	/**
	 * @see java.util.Map#putAll(java.util.Map)
	 */
	@Override
	public void putAll(final Map<? extends String, ? extends Serializable> t) {
		throw new UnsupportedOperationException();
	}

	/**
	 * @see java.util.Map#entrySet()
	 */
	@Override
	public Set<Entry<String, Serializable>> entrySet() {
		throw new UnsupportedOperationException();
	}

	/**
	 * @see java.util.Map#keySet()
	 */
	@Override
	public Set<String> keySet() {
		return this.sanitary.keySet();
	}

	/**
	 * @see java.util.Map#get(java.lang.Object)
	 */
	@Override
	public Serializable get(final Object key) {
		if (ATTR_UNSANI.equals(key)) {
			return this.unsanitary;
		}

		return this.sanitary.get(String.class.cast(key));
	}

	/**
	 * @see java.util.Map#remove(java.lang.Object)
	 */
	@Override
	public Serializable remove(final Object key) {
		throw new UnsupportedOperationException();
	}

	/**
	 * @param key キー
	 * @param value 値
	 * @return 既存値
	 * @see java.util.Map#put(java.lang.Object, java.lang.Object)
	 */
	@Override
	public Serializable put(final String key, final Serializable value) {
		throw new UnsupportedOperationException();
	}
}
