package online.view.tag;

import javax.servlet.jsp.JspException;

/**
 * リライトタグ
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public class RewriteTag extends BaseTag {
	/** serialVersionUID */
	private static final long serialVersionUID = 1L;

	/** 保存変数名 */
	private String var = null;
	/** 値 */
	private String value = null;

	/**
	 * リリース処理
	 */
	@Override
	public void release() {
		this.var = null;
		this.value = null;
	}

	/**
	 * 変数設定
	 *
	 * @param val 保存変数名文字列
	 */
	public void setVar(final String val) {
		this.var = val;
	}

	/**
	 * 値設定
	 *
	 * @param val 値
	 */
	public void setValue(final String val) {
		this.value = val;
	}

	/**
	 * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
	 */
	@Override
	public int doStartTag() throws JspException {
		try {
			if (this.var != null) {
				this.pageContext.removeAttribute(this.var);
			}

			super.output(this.var, super.getResponse().encodeURL(this.value));
			return SKIP_BODY;
		} finally {
			release();
		}
	}
}
