package online.jpa.extension;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;

/**
 * ProxyQuery
 *
 * @author Tadashi Nakayama
 */
public final class ProxyQuery implements ExQuery {

    /** Query */
    private Query query;

    /**
     * Constructor
     * @param val Query
     */
    public ProxyQuery(final Query val) {
        this.query = val;
    }

    /**
     * @see online.jpa.extension.ExQuery#getResult()
     */
    @Override
    public <T> T getResult() {
        return (T) this.query.getSingleResult();
    }

    /**
     * @see javax.persistence.Query#executeUpdate()
     */
    @Override
    public int executeUpdate() {
        return this.query.executeUpdate();
    }

    /**
     * @see javax.persistence.Query#getResultList()
     */
    @Override
    public List getResultList() {
        return this.query.getResultList();
    }

    /**
     * @see javax.persistence.Query#getSingleResult()
     */
    @Override
    public Object getSingleResult() {
        return this.query.getSingleResult();
    }

    /**
     * @see javax.persistence.Query#setFirstResult(int)
     */
    @Override
    public Query setFirstResult(final int arg0) {
        return new ProxyQuery(this.query.setFirstResult(arg0));
    }

    /**
     * @see javax.persistence.Query#setFlushMode(javax.persistence.FlushModeType)
     */
    @Override
    public Query setFlushMode(final FlushModeType arg0) {
        return new ProxyQuery(this.query.setFlushMode(arg0));
    }

    /**
     * @see javax.persistence.Query#setHint(java.lang.String, java.lang.Object)
     */
    @Override
    public Query setHint(final String arg0, final Object arg1) {
        return new ProxyQuery(this.query.setHint(arg0, arg1));
    }

    /**
     * @see javax.persistence.Query#setMaxResults(int)
     */
    @Override
    public Query setMaxResults(final int arg0) {
        return new ProxyQuery(this.query.setMaxResults(arg0));
    }

    /**
     * @see javax.persistence.Query#setParameter(java.lang.String, java.lang.Object)
     */
    @Override
    public Query setParameter(final String arg0, final Object arg1) {
        return new ProxyQuery(this.query.setParameter(arg0, arg1));
    }

    /**
     * @see javax.persistence.Query#setParameter(int, java.lang.Object)
     */
    @Override
    public Query setParameter(final int arg0, final Object arg1) {
        return new ProxyQuery(this.query.setParameter(arg0, arg1));
    }

    /**
     * @see javax.persistence.Query
     * #setParameter(java.lang.String, java.util.Date, javax.persistence.TemporalType)
     */
    @Override
    public Query setParameter(final String arg0, final Date arg1, final TemporalType arg2) {
        return new ProxyQuery(this.query.setParameter(arg0, arg1, arg2));
    }

    /**
     * @see javax.persistence.Query
     * #setParameter(java.lang.String, java.util.Calendar, javax.persistence.TemporalType)
     */
    @Override
    public Query setParameter(final String arg0, final Calendar arg1, final TemporalType arg2) {
        return new ProxyQuery(this.query.setParameter(arg0, arg1, arg2));
    }

    /**
     * @see javax.persistence.Query
     * #setParameter(int, java.util.Date, javax.persistence.TemporalType)
     */
    @Override
    public Query setParameter(final int arg0, final Date arg1, final TemporalType arg2) {
        return new ProxyQuery(this.query.setParameter(arg0, arg1, arg2));
    }

    /**
     * @see javax.persistence.Query
     * #setParameter(int, java.util.Calendar, javax.persistence.TemporalType)
     */
    @Override
    public Query setParameter(final int arg0, final Calendar arg1, final TemporalType arg2) {
        return new ProxyQuery(this.query.setParameter(arg0, arg1, arg2));
    }

    /**
     * @see javax.persistence.Query#getFirstResult()
     */
    @Override
    public int getFirstResult() {
        return this.query.getFirstResult();
    }

    /**
     * @see javax.persistence.Query#getFlushMode()
     */
    @Override
    public FlushModeType getFlushMode() {
        return this.query.getFlushMode();
    }

    /**
     * @see javax.persistence.Query#getHints()
     */
    @Override
    public Map<String, Object> getHints() {
        return this.query.getHints();
    }

    /**
     * @see javax.persistence.Query#getLockMode()
     */
    @Override
    public LockModeType getLockMode() {
        return this.query.getLockMode();
    }

    /**
     * @see javax.persistence.Query#getMaxResults()
     */
    @Override
    public int getMaxResults() {
        return this.query.getMaxResults();
    }

    /**
     * @see javax.persistence.Query#getParameter(java.lang.String)
     */
    @Override
    public Parameter<?> getParameter(final String arg0) {
        return this.query.getParameter(arg0);
    }

    /**
     * @see javax.persistence.Query#getParameter(int)
     */
    @Override
    public Parameter<?> getParameter(final int arg0) {
        return this.query.getParameter(arg0);
    }

    /**
     * @see javax.persistence.Query#getParameter(java.lang.String, java.lang.Class)
     */
    @Override
    public <T> Parameter<T> getParameter(final String arg0, final Class<T> arg1) {
        return this.query.getParameter(arg0, arg1);
    }

    /**
     * @see javax.persistence.Query#getParameter(int, java.lang.Class)
     */
    @Override
    public <T> Parameter<T> getParameter(final int arg0, final Class<T> arg1) {
        return this.query.getParameter(arg0, arg1);
    }

    /**
     * @see javax.persistence.Query#getParameterValue(javax.persistence.Parameter)
     */
    @Override
    public <T> T getParameterValue(final Parameter<T> arg0) {
        return this.query.getParameterValue(arg0);
    }

    /**
     * @see javax.persistence.Query#getParameterValue(java.lang.String)
     */
    @Override
    public Object getParameterValue(final String arg0) {
        return this.query.getParameterValue(arg0);
    }

    /**
     * @see javax.persistence.Query#getParameterValue(int)
     */
    @Override
    public Object getParameterValue(final int arg0) {
        return this.query.getParameterValue(arg0);
    }

    /**
     * @see javax.persistence.Query#getParameters()
     */
    @Override
    public Set<Parameter<?>> getParameters() {
        return this.query.getParameters();
    }

    /**
     * @see javax.persistence.Query#isBound(javax.persistence.Parameter)
     */
    @Override
    public boolean isBound(final Parameter<?> arg0) {
        return this.query.isBound(arg0);
    }

    /**
     * @see javax.persistence.Query#setLockMode(javax.persistence.LockModeType)
     */
    @Override
    public Query setLockMode(final LockModeType arg0) {
        return this.query.setLockMode(arg0);
    }

    /**
     * @see javax.persistence.Query#setParameter(javax.persistence.Parameter, java.lang.Object)
     */
    @Override
    public <T> Query setParameter(final Parameter<T> arg0, final T arg1) {
        return this.query.setParameter(arg0, arg1);
    }

    /**
     * @see javax.persistence.Query#setParameter(
     * javax.persistence.Parameter, java.util.Calendar, javax.persistence.TemporalType)
     */
    @Override
    public Query setParameter(
            final Parameter<Calendar> arg0, final Calendar arg1, final TemporalType arg2) {
        return this.query.setParameter(arg0, arg1, arg2);
    }

    /**
     * @see javax.persistence.Query
     * #setParameter(javax.persistence.Parameter, java.util.Date, javax.persistence.TemporalType)
     */
    @Override
    public Query setParameter(
            final Parameter<Date> arg0, final Date arg1, final TemporalType arg2) {
        return this.query.setParameter(arg0, arg1, arg2);
    }

    /**
     * @see javax.persistence.Query#unwrap(java.lang.Class)
     */
    @Override
    public <T> T unwrap(final Class<T> arg0) {
        return this.query.unwrap(arg0);
    }
}
