CREATE TABLE FW_JOB_BASE
(
  JOB_SEQ             BIGINT         PRIMARY KEY,
  JOB_ID              VARCHAR(32)   NOT NULL,
  JOB_NAME            VARCHAR(128)  NOT NULL,
  ENTRY_USER_ID       VARCHAR(64)   NOT NULL,
  ENTRY_DATE_TIME     TIMESTAMP     NOT NULL,
  ENTRY_IP            VARCHAR(64),
  JOB_PARAM           VARCHAR(128),
  BAT_PARAM           VARCHAR(512),
  DISP_PARAM          VARCHAR(512),
  EXEC_HOST           VARCHAR(64),
  STATUS              SMALLINT       NOT NULL,
  MESSAGE             VARCHAR(512),
  REMARK              VARCHAR(256)
)
;

COMMENT ON TABLE FW_JOB_BASE IS 'ジョブ管理';
COMMENT ON COLUMN FW_JOB_BASE.JOB_SEQ IS 'ジョブ連番';
COMMENT ON COLUMN FW_JOB_BASE.JOB_ID IS 'ジョブID';
COMMENT ON COLUMN FW_JOB_BASE.JOB_NAME IS 'ジョブ名';
COMMENT ON COLUMN FW_JOB_BASE.ENTRY_USER_ID IS '起動ユーザ';
COMMENT ON COLUMN FW_JOB_BASE.ENTRY_DATE_TIME IS '起動日時';
COMMENT ON COLUMN FW_JOB_BASE.ENTRY_IP IS '起動端末IP';
COMMENT ON COLUMN FW_JOB_BASE.JOB_PARAM IS 'ジョブ起動パラメタ';
COMMENT ON COLUMN FW_JOB_BASE.BAT_PARAM IS 'バッチ起動パラメタ';
COMMENT ON COLUMN FW_JOB_BASE.DISP_PARAM IS 'バッチ起動パラメタ（表示用）';
COMMENT ON COLUMN FW_JOB_BASE.EXEC_HOST IS '実行ホスト名';
COMMENT ON COLUMN FW_JOB_BASE.STATUS IS 'ステータス';
COMMENT ON COLUMN FW_JOB_BASE.MESSAGE IS 'メッセージ';
COMMENT ON COLUMN FW_JOB_BASE.REMARK IS '備考';
