package project.filter.develop.struts;

import java.io.File;
import java.util.Objects;

import javax.servlet.ServletContext;

import org.apache.catalina.Globals;
import org.apache.logging.log4j.LogManager;

import javassist.ClassPool;
import javassist.NotFoundException;
import online.filter.develop.S2HotDeploy;

/**
 * HotDeploy用ユーティリティ
 * @author Tadashi Nakayama
 */
public interface HbS2HotDeploy extends S2HotDeploy {

	/**
	 * クラスパス設定
	 * @param context サーブレットコンテキスト
	 */
	default void setClassPath(final ServletContext context) {
		final String path = Objects.toString(context.getAttribute(Globals.CLASS_PATH_ATTR), "");
		final ClassPool pool = ClassPool.getDefault();
		for (final String str : path.split(File.pathSeparator)) {
			try {
				if (!str.isEmpty()) {
					pool.appendClassPath(str);
				}
			} catch (final NotFoundException e) {
				LogManager.getLogger().info(e.getMessage());
			}
		}
	}
}
