package project.view.tag;

import javax.servlet.jsp.JspException;

import online.view.tag.BaseTag;

/**
 * コメントタグライブラリ
 * <!-- <view:comment>  </view:comment> --> でランタイム時に有効にする部分をくくる
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class CommentTag extends BaseTag {
	/** serialVersionUID */
	private static final long serialVersionUID = 1L;

	/**
	 * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
	 */
	@Override
	public int doStartTag() throws JspException {
		super.output(null, "-->");
		return EVAL_BODY_INCLUDE;
	}

	/**
	 * @see javax.servlet.jsp.tagext.TagSupport#doEndTag()
	 */
	@Override
	public int doEndTag() throws JspException {
		super.output(null, "<!--");
		return EVAL_PAGE;
	}
}
