package project.view.tag;

import javax.servlet.jsp.JspException;

import online.view.tag.BaseTag;

/**
 * リフレッシュタグ
 * @author Tadashi Nakayama
 */
public final class RefreshTag extends BaseTag {
	/** serialVersionUID */
	private static final long serialVersionUID = 1L;

	/** 秒 */
	private int second;
	/** URL */
	private String url;

	/**
	 * リリース処理
	 */
	@Override
	public void release() {
		this.second = 0;
		this.url = null;
	}

	/**
	 * 秒数設定
	 * @param val 秒数
	 */
	public void setSec(final int val) {
		this.second = val;
	}

	/**
	 * URL設定
	 * @param val URL
	 */
	public void setUrl(final String val) {
		this.url = val;
	}

	/**
	 * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
	 */
	@Override
	public int doStartTag() throws JspException {
		super.getResponse().addHeader("Refresh", this.second + "; url=" + this.url);
		return SKIP_BODY;
	}
}
