package project.web.generic.master;

import online.context.check.InputCheck;
import online.model.Band;
import online.model.UniModel;
import online.model.UniModelImpl;
import online.struts.action.BrowseAction;
import online.struts.action.UniForm;
import project.check.attribute.LongNumeralCheck;
import project.master.MsgUtil;
import project.svc.generic.db.RecordOperate;
import project.web.InstanceFactory;
import project.web.generic.SearchAction;

/**
 * 汎用一覧画面
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class ListAction implements BrowseAction {

	/** 削除ID */
	private static final String DEL_ID = "DelId";

	/** クエリ */
	private String query = null;

	/**
	 * クエリ設定
	 *
	 * @param qry クエリファイル
	 */
	public void setQueryFile(final String qry) {
		this.query = qry;
	}

	/**
	 * 表示処理
	 *
	 * @param model 汎用データモデル
	 * @return 処理結果
	 */
	public String get(final UniForm model) {
		final SearchAction action = new SearchAction();
		action.setQueryFile(this.query);
		return action.get(model);
	}

	/**
	 * 削除処理
	 *
	 * @param model 汎用データモデル
	 * @return 処理結果
	 */
	public String delete(final UniForm model) {
		if (model.hasQueryString()) {
			// 入力チェック
			final InputCheck ic = InstanceFactory.create(InputCheck.class, model);
			ic.add(DEL_ID, new LongNumeralCheck());
			ic.populate();

			// TODO 権限確認
			final RecordOperate ro = InstanceFactory.create(RecordOperate.class, model);
			for (final Band band : Band.iterable(model, DEL_ID)) {
				final UniModel um = new UniModelImpl();
				if (ro.find(band.number(DEL_ID), um)) {
					if (!ro.delete(um.getNumber("Id"), um.getNumber("Version"))) {
						// 削除失敗
						MsgUtil.putTopMessage(model, "ZZ000000017");
						return ID_NG;
					}
				}
			}
		}
		return ID_OK;
	}
}
