package online.model;

import java.io.Serializable;
import java.lang.reflect.Array;

import org.junit.Assert;
import org.junit.Test;

/**
 * TestUniMap
 *
 */
public class TestUniMap {

	/**
	 * testArraySize1
	 */
	@Test
	public void testArraySize1() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", null, String.class);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertFalse(um.isArrayValue("aaaaa"));
		Assert.assertEquals("{aaaaa=null}", um.toString());
		Assert.assertNull(um.get("aaaaa"));
	}

	/**
	 * testArraySize2
	 */
	@Test
	public void testArraySize2() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", null, String[].class);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertTrue(um.isArrayValue("aaaaa"));
		Assert.assertEquals("{aaaaa=null}", um.toString());
		Assert.assertNull(um.get("aaaaa"));
	}

	/**
	 * testArraySize3
	 */
	@Test
	public void testArraySize3() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", new String[]{null});
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertTrue(um.isArrayValue("aaaaa"));
		Assert.assertEquals("{aaaaa=[null]}", um.toString());
		Assert.assertNull(Array.get(um.get("aaaaa"), 0));
	}

	/**
	 * testArraySize4
	 */
	@Test
	public void testArraySize4() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", new String[][]{new String[]{null}});
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertTrue(um.isArrayValue("aaaaa"));
		Assert.assertEquals("{aaaaa=[[null]]}", um.toString());
		Assert.assertNull(Array.get(Array.get(um.get("aaaaa"), 0), 0));
	}

	/**
	 * testArraySize5
	 */
	@Test
	public void testArraySize5() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", new String[0]);
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertTrue(um.isArrayValue("aaaaa"));
		Assert.assertEquals("{aaaaa=[]}", um.toString());
		Assert.assertEquals(0, Array.getLength(um.get("aaaaa")));
	}

	/**
	 * testArraySize6
	 */
	@Test
	public void testArraySize6() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", new String[0][0]);
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertTrue(um.isArrayValue("aaaaa"));
		Assert.assertEquals("{aaaaa=[[]]}", um.toString());
		Assert.assertEquals(String[][].class, um.get("aaaaa").getClass());
	}

	/**
	 * testArraySize7
	 */
	@Test
	public void testArraySize7() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.putRaw("aaaaa", new String[0]);
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertFalse(um.isArrayValue("aaaaa"));
		Assert.assertEquals("{aaaaa=null}", um.toString());
		Assert.assertNull(um.get("aaaaa"));
	}

	/**
	 * testArraySize8
	 */
	@Test
	public void testArraySize8() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.putRaw("aaaaa", new String[0][0]);
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertTrue(um.isArrayValue("aaaaa"));
		Assert.assertEquals("{aaaaa=null}", um.toString());
		Assert.assertNull(um.get("aaaaa"));
	}

	/**
	 * testArraySize9
	 */
	@Test
	public void testArraySize9() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.putRaw("aaaaa", new String[1][0]);
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertTrue(um.isArrayValue("aaaaa"));
		Assert.assertEquals("{aaaaa=[]}", um.toString());
		Assert.assertEquals(0, Array.getLength(um.get("aaaaa")));
	}


	/**
	 * testToArray1
	 */
	@Test
	public void testToArray1() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", null);
		Assert.assertFalse(um.isArrayValue("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));

		Assert.assertTrue(um.toArrayValue("aaaaa"));

		Assert.assertTrue(um.isArrayValue("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
	}

	/**
	 * testToArray2
	 */
	@Test
	public void testToArray2() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", null, String[].class);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));

		Assert.assertFalse(um.toArrayValue("aaaaa"));

		Assert.assertTrue(um.isArrayValue("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
	}

	/**
	 * testToArray3
	 */
	@Test
	public void testToArray3() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", new String[]{null, null});
		Assert.assertTrue(um.isArrayValue("aaaaa"));
		Assert.assertEquals(2, um.getArraySize("aaaaa"));

		Assert.assertFalse(um.toArrayValue("aaaaa"));

		Assert.assertTrue(um.isArrayValue("aaaaa"));
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
	}

}
