package online.model;

import java.util.Date;

import org.junit.Assert;
import org.junit.Test;

import test.AssertUtil;

/**
 * TestUniModelDate
 *
 */
public class TestUniModelDate {

	/**
	 * noValueTest1
	 */
	@Test
	public void noValueTest1() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("AAAAA");

		Assert.assertTrue(um.containsKey("AAAAA"));
		Assert.assertFalse(um.hasValue("AAAAA"));
		Assert.assertNull(um.getDate("AAAAA"));
		Assert.assertEquals(0, um.getArraySize("AAAAA"));
		Assert.assertEquals(0, um.getDateArray("AAAAA").length);
		Assert.assertFalse(um.isArrayValue("AAAAA"));

		final Date now = new Date();
		um.addValue("AAAAA", now);
		Assert.assertTrue(um.containsKey("AAAAA"));
		Assert.assertTrue(um.hasValue("AAAAA"));
		Assert.assertEquals(now, um.getDate("AAAAA"));
		Assert.assertEquals(1, um.getArraySize("AAAAA"));
		Assert.assertEquals(1, um.getDateArray("AAAAA").length);
		Assert.assertFalse(um.isArrayValue("AAAAA"));
	}

	/**
	 * noValueTest2
	 */
	@Test
	public void noValueTest2() {
		final Date now = new Date();
		final UniModelImpl um = new UniModelImpl();
		um.setValue("AAAAA", now);

		Assert.assertTrue(um.containsKey("AAAAA"));
		Assert.assertTrue(um.hasValue("AAAAA"));
		Assert.assertEquals(now, um.getDate("AAAAA"));
		Assert.assertEquals(now, um.getDateArray("AAAAA")[0]);
		Assert.assertEquals(1, um.getArraySize("AAAAA"));
		Assert.assertEquals(1, um.getDateArray("AAAAA").length);
		Assert.assertFalse(um.isArrayValue("AAAAA"));

		um.noValue("AAAAA");
		Assert.assertTrue(um.containsKey("AAAAA"));
		Assert.assertFalse(um.hasValue("AAAAA"));
		Assert.assertNull(um.getDate("AAAAA"));
		Assert.assertEquals(0, um.getArraySize("AAAAA"));
		Assert.assertEquals(0, um.getDateArray("AAAAA").length);
		Assert.assertFalse(um.isArrayValue("AAAAA"));

		final Date now1 = new Date();
		um.addValue("AAAAA", now1);
		final Date now2 = new Date();
		um.addValue("AAAAA", now2);
		Assert.assertTrue(um.containsKey("AAAAA"));
		Assert.assertTrue(um.hasValue("AAAAA"));
		Assert.assertEquals(2, um.getArraySize("AAAAA"));
		Assert.assertEquals(2, um.getDateArray("AAAAA").length);
		Assert.assertEquals(now1, um.getDateArray("AAAAA")[0]);
		Assert.assertEquals(now2, um.getDateArray("AAAAA")[1]);
		Assert.assertTrue(um.isArrayValue("AAAAA"));
	}


	/**
	 * aliasKeyTest0
	 */
	@Test
	public void aliasKeyTest0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("BBBBB");
		um.aliasKey("BBBBB", "AAAAA");

		Assert.assertTrue(um.containsKey("BBBBB"));
		Assert.assertTrue(um.containsKey("AAAAA"));
		Assert.assertFalse(um.hasValue("AAAAA"));
		Assert.assertNull(um.getDate("AAAAA"));
		Assert.assertEquals(0, um.getArraySize("AAAAA"));
		Assert.assertEquals(0, um.getDateArray("AAAAA").length);
		Assert.assertFalse(um.isArrayValue("AAAAA"));
	}

	/**
	 * aliasKeyTest1
	 */
	@Test
	public void aliasKeyTest1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Date)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertFalse(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getDateArray("aaaaa").length);
		Assert.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * aliasKeyTest2
	 */
	@Test
	public void aliasKeyTest2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Date[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertFalse(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getDateArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * aliasKeyTest3
	 */
	@Test
	public void aliasKeyTest3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Date)null);
		um.addValue("bbbbb", (Date)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * aliasKeyTest4
	 */
	@Test
	public void aliasKeyTest4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", new Date[]{null});
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDateArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * aliasKeyTest5
	 */
	@Test
	public void aliasKeyTest5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (Date)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDateArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertFalse(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Date)null);
		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDateArray("aaaaa")[1]);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		Assert.assertTrue(um.containsKey("bbbbb"));
		Assert.assertTrue(um.hasValue("bbbbb"));
		Assert.assertNull(um.getDateArray("bbbbb")[0]);
		Assert.assertEquals(1, um.getArraySize("bbbbb"));
		Assert.assertEquals(1, um.getDateArray("bbbbb").length);
		Assert.assertFalse(um.isArrayValue("bbbbb"));
	}

	/**
	 * aliasKeyTest6
	 */
	@Test
	public void aliasKeyTest6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Date[])null);
		um.addValue("bbbbb", (Date)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * aliasKeyTest7
	 */
	@Test
	public void aliasKeyTest7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (Date[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDateArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		final Date now1 = new Date();
		final Date now2 = new Date();
		um.addValue("aaaaa", new Date[]{now1, now2});
		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertEquals(now1, um.getDateArray("aaaaa")[1]);
		Assert.assertEquals(now2, um.getDateArray("aaaaa")[2]);
		Assert.assertEquals(3, um.getArraySize("aaaaa"));
		Assert.assertEquals(3, um.getDateArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		Assert.assertTrue(um.containsKey("bbbbb"));
		Assert.assertTrue(um.hasValue("bbbbb"));
		Assert.assertNull(um.getDateArray("bbbbb")[0]);
		Assert.assertEquals(1, um.getArraySize("bbbbb"));
		Assert.assertEquals(1, um.getDateArray("bbbbb").length);
		Assert.assertTrue(um.isArrayValue("bbbbb"));
	}

	/**
	 * aliasKeyTest8
	 */
	@Test
	public void aliasKeyTest8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (Date[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDateArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Date)null);
		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDateArray("aaaaa")[1]);
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getDateArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		Assert.assertTrue(um.containsKey("bbbbb"));
		Assert.assertTrue(um.hasValue("bbbbb"));
		Assert.assertNull(um.getDateArray("bbbbb")[0]);
		Assert.assertEquals(1, um.getArraySize("bbbbb"));
		Assert.assertEquals(1, um.getDateArray("bbbbb").length);
		Assert.assertTrue(um.isArrayValue("bbbbb"));
	}


	/**
	 * arraySizeTest1
	 */
	@Test
	public void arraySizeTest1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date)null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertFalse(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getDateArray("aaaaa").length);
		Assert.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * arraySizeTest2
	 */
	@Test
	public void arraySizeTest2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date[])null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertFalse(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getDateArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * arraySizeTest3
	 */
	@Test
	public void arraySizeTest3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date)null);
		um.addValue("aaaaa", (Date)null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * arraySizeTest4
	 */
	@Test
	public void arraySizeTest4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Date[]{null});

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDateArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * arraySizeTest5
	 */
	@Test
	public void arraySizeTest5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date)null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDateArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertFalse(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Date)null);
		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDateArray("aaaaa")[1]);
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getDateArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * arraySizeTest6
	 */
	@Test
	public void arraySizeTest6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date[])null);
		um.addValue("aaaaa", (Date)null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * arraySizeTest7
	 */
	@Test
	public void arraySizeTest7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date[])null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDateArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		final Date now1 = new Date();
		final Date now2 = new Date();
		um.addValue("aaaaa", new Date[]{now1, now2});
		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertEquals(now1, um.getDateArray("aaaaa")[1]);
		Assert.assertEquals(now2, um.getDateArray("aaaaa")[2]);
		Assert.assertEquals(3, um.getArraySize("aaaaa"));
		Assert.assertEquals(3, um.getDateArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * arraySizeTest8
	 */
	@Test
	public void arraySizeTest8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date[])null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDateArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Date)null);
		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getDateArray("aaaaa")[1]);
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getDateArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}


	/**
	 * copyValueTest0
	 */
	@Test
	public void copyValueTest0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * copyValueTest1
	 */
	@Test
	public void copyValueTest1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * copyValueTest2
	 */
	@Test
	public void copyValueTest2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date[])null);
		um.setValue("bbbbb", new Date[0]);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * copyValueTest3
	 */
	@Test
	public void copyValueTest3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date)null);
		um.addValue("aaaaa", (Date)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * copyValueTest4
	 */
	@Test
	public void copyValueTest4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Date[]{null});

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * copyValueTest5
	 */
	@Test
	public void copyValueTest5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Date)null);
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertEquals(um.getDateArray("aaaaa")[1], um1.getDateArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * copyValueTest6
	 */
	@Test
	public void copyValueTest6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date[])null);
		um.addValue("aaaaa", (Date)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * copyValueTest7
	 */
	@Test
	public void copyValueTest7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		final Date now1 = new Date();
		final Date now2 = new Date();
		um.addValue("aaaaa", new Date[]{now1, now2});
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa")[1], um1.getDateArray("aaaaa")[1]);
		Assert.assertEquals(um.getDateArray("aaaaa")[2], um1.getDateArray("aaaaa")[2]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * copyValueTest8
	 */
	@Test
	public void copyValueTest8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Date)null);
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa")[1], um1.getDateArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}


	/**
	 * putValueTest0
	 */
	@Test
	public void putValueTest0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * putValueTest1
	 */
	@Test
	public void putValueTest1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * putValueTest2
	 */
	@Test
	public void putValueTest2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * putValueTest3
	 */
	@Test
	public void putValueTest3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date)null);
		um.addValue("aaaaa", (Date)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * putValueTest4
	 */
	@Test
	public void putValueTest4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Date[]{null});

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * putValueTest5
	 */
	@Test
	public void putValueTest5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Date)null);
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertEquals(um.getDateArray("aaaaa")[1], um1.getDateArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * putValueTest6
	 */
	@Test
	public void putValueTest6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date[])null);
		um.addValue("aaaaa", (Date)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * putValueTest7
	 */
	@Test
	public void putValueTest7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		final Date now1 = new Date();
		final Date now2 = new Date();
		um.addValue("aaaaa", new Date[]{now1, now2});
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa")[1], um1.getDateArray("aaaaa")[1]);
		Assert.assertEquals(um.getDateArray("aaaaa")[2], um1.getDateArray("aaaaa")[2]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * putValueTest8
	 */
	@Test
	public void putValueTest8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Date)null);
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa")[1], um1.getDateArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}


	/**
	 * putAllTest0
	 */
	@Test
	public void putAllTest0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * putAllTest1
	 */
	@Test
	public void putAllTest1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * putAllTest2
	 */
	@Test
	public void putAllTest2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * putAllTest3
	 */
	@Test
	public void putAllTest3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date)null);
		um.addValue("aaaaa", (Date)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * putAllTest4
	 */
	@Test
	public void putAllTest4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Date[]{null});

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * putAllTest5
	 */
	@Test
	public void putAllTest5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Date)null);
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertEquals(um.getDateArray("aaaaa")[1], um1.getDateArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * putAllTest6
	 */
	@Test
	public void putAllTest6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date[])null);
		um.addValue("aaaaa", (Date)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * putAllTest7
	 */
	@Test
	public void putAllTest7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		final Date now1 = new Date();
		final Date now2 = new Date();
		um.addValue("aaaaa", new Date[]{now1, now2});
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa")[1], um1.getDateArray("aaaaa")[1]);
		Assert.assertEquals(um.getDateArray("aaaaa")[2], um1.getDateArray("aaaaa")[2]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * putAllTest8
	 */
	@Test
	public void putAllTest8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Date)null);
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa")[1], um1.getDateArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}


	/**
	 * addAllTest0
	 */
	@Test
	public void addAllTest0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		final UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * addAllTest1
	 */
	@Test
	public void addAllTest1() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		Assert.assertTrue(um1.containsKey("aaaaa"));
		Assert.assertTrue(um1.hasValue("aaaaa"));
		Assert.assertEquals(1, um1.getArraySize("aaaaa"));
		Assert.assertNull(um1.getDateArray("aaaaa")[0]);
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertFalse(um1.isArrayValue("aaaaa"));
	}

	/**
	 * addAllTest2
	 */
	@Test
	public void addAllTest2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		Assert.assertTrue(um1.containsKey("aaaaa"));
		Assert.assertTrue(um1.hasValue("aaaaa"));
		Assert.assertEquals(1, um1.getArraySize("aaaaa"));
		Assert.assertNull(um1.getDateArray("aaaaa")[0]);
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertFalse(um1.isArrayValue("aaaaa"));
	}

	/**
	 * addAllTest3
	 */
	@Test
	public void addAllTest3() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.addValue("aaaaa", (Date)null);
		um1.addAll(um);

		Assert.assertTrue(um1.containsKey("aaaaa"));
		Assert.assertTrue(um1.hasValue("aaaaa"));
		Assert.assertEquals(2, um1.getArraySize("aaaaa"));
		Assert.assertNull(um1.getDateArray("aaaaa")[0]);
		Assert.assertNull(um1.getDateArray("aaaaa")[1]);
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertTrue(um1.isArrayValue("aaaaa"));
	}
}
