/*
 * (c) Copyright Sysdeo SA 2001, 2002.
 * All Rights Reserved.
 */

package com.sysdeo.eclipse.tomcat;

import java.io.File;
import java.io.FilenameFilter;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;


/**
 * See %TOMCAT3_HOME%/bin/tomcat.bat
 */
public class Tomcat3Bootstrap extends TomcatBootstrap {

	/** DEBUG_VIEW_LABEL */
	private static final String DEBUG_VIEW_LABEL = "Tomcat 3.3";

	/**
	 * @see TomcatBootstrap#getClasspath()
	 */
	@Override
	public String[] getClasspath() {
		String[] classpath = new String[1];

		//		String toolsJarLocation = VMLauncherUtility.getVMInstall().getInstallLocation()
		//						+ File.separator + "lib" + File.separator + "tools.jar";
		//		classpath[0] = toolsJarLocation;

		File libDir = new File(getTomcatDir() + File.separator + "lib");
		classpath = addJarsOfDirectory(classpath, libDir);

		File containerDir = new File(getTomcatDir() + File.separator + "lib" + File.separator + "container");
		classpath = addJarsOfDirectory(classpath, containerDir);

		File commonDir = new File(getTomcatDir() + File.separator + "lib" + File.separator + "common");
		classpath = addJarsOfDirectory(classpath, commonDir);

		File appsDir = new File(getTomcatDir() + File.separator + "lib" + File.separator + "apps");
		classpath = addJarsOfDirectory(classpath, appsDir);

		return classpath;
	}

	/**
	 * @see TomcatBootstrap#getMainClass()
	 */
	@Override
	public String getMainClass() {
		return "org.apache.tomcat.startup.Main";
	}

	/**
	 * @see TomcatBootstrap#getStartCommand()
	 */
	@Override
	public String getStartCommand() {
		return "start";
	}

	/**
	 * @see TomcatBootstrap#getStopCommand()
	 */
	@Override
	public String getStopCommand() {
		return "stop";
	}


	/**
	 * @see com.sysdeo.eclipse.tomcat.TomcatBootstrap#getPrgArgs(java.lang.String)
	 */
	@Override
	public String[] getPrgArgs(final String command) {
		String[] prgArgs = null;
		if (command.equals(getStartCommand())) {
			prgArgs = new String[3];
			prgArgs[0] = command;
			prgArgs[1] = "-config";
			prgArgs[2] = TomcatLauncherPlugin.getConfigFile();
		} else {
			prgArgs = new String[1];
			prgArgs[0] = command;
		}
		return prgArgs;
	}

	/**
	 * @see TomcatBootstrap#getVmArgs()
	 */
	@Override
	public String[] getVmArgs() {
		String[] vmArgs = new String[1];
		vmArgs[0] = "-Dtomcat.home=" + getTomcatDir();

		return vmArgs;
	}

	/**
	 * Add all jar files of directory dir to previous array
	 *
	 * @param previous String[]
	 * @param dir File
	 * @return String[]
	 */
	private String[] addJarsOfDirectory(final String[] previous, final File dir) {
		if ((dir != null) && (dir.isDirectory())) {

			String[] jars = new String[0];

			// Filter for .jar files
			File[] files = dir.listFiles(new FileNameFilter());
			if (files != null) {
				jars = new String[files.length];
				for (int i = 0; i < files.length; i++) {
					jars[i] = files[i].getAbsolutePath();
				}
			}

			return StringUtil.concat(previous, jars);
		}
		return previous;
	}

	/**
	 * @see TomcatBootstrap#getXMLTagAfterContextDefinition()
	 */
	@Override
	public String getXMLTagAfterContextDefinition() {
		return "</ContextManager>";
	}


	/**
	 * @see com.sysdeo.eclipse.tomcat.TomcatBootstrap#getServletJarPath()
	 */
	@Override
	public IPath getServletJarPath() {
		return new Path("lib").append("common").append("servlet.jar");
	}

	/**
	 * @see com.sysdeo.eclipse.tomcat.TomcatBootstrap#getJasperJarPath()
	 */
	@Override
	public IPath getJasperJarPath() {
		return new Path("lib").append("common").append("jasper-runtime.jar");
	}

	/**
	 * @see TomcatBootstrap#getLabel()
	 */
	@Override
	public String getLabel() {
		return DEBUG_VIEW_LABEL;
	}

	/**
	 * @see com.sysdeo.eclipse.tomcat.TomcatBootstrap#getContextWorkDir(java.lang.String)
	 */
	@Override
	public String getContextWorkDir(final String workFolder) {
		StringBuilder workDir = new StringBuilder("workDir=");
		workDir.append('"');
		workDir.append(workFolder);
		workDir.append('"');
		return workDir.toString();
	}

	/**
	 * No JSP jar for Tomcat 3, JSP classes are in servlet jar
	 */
	@Override
	public IPath getJSPJarPath() {
		return null;
	}

	/**
	 * @see com.sysdeo.eclipse.tomcat.TomcatBootstrap#getElJarPath()
	 */
	@Override
	public IPath getElJarPath() {
		return null;
	}

	/**
	 * @see com.sysdeo.eclipse.tomcat.TomcatBootstrap#getAnnotationsJarPath()
	 */
	@Override
	public IPath getAnnotationsJarPath() {
		return null;
	}

	/**
	 * FileNameFilter
	 *
	 */
	static final class FileNameFilter implements FilenameFilter {
		/**
		 * @see java.io.FilenameFilter#accept(java.io.File, java.lang.String)
		 */
		@Override
		public boolean accept(final File dir, final String filename) {
			return filename.endsWith(".jar");
		}
	}
}
