package online.listener;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.apache.logging.log4j.LogManager;
import org.seasar.extension.timer.TimeoutManager;

/**
 * TimeoutManager停止リスナ
 * @author Tadashi Nakayama
 */
public class S2ContextListener implements ServletContextListener {

    /**
     * @see javax.servlet.ServletContextListener
     * #contextDestroyed(javax.servlet.ServletContextEvent)
     */
    @Override
    public void contextDestroyed(final ServletContextEvent arg0) {
        if (!TimeoutManager.getInstance().stop(3000)) {
            LogManager.getLogger().info("TimeoutManager is still alive.");
        }
    }

    /**
     * @see javax.servlet.ServletContextListener
     * #contextInitialized(javax.servlet.ServletContextEvent)
     */
    @Override
    public void contextInitialized(final ServletContextEvent arg0) {
        return;
    }
}
