/*
 * Copyright 2004-2014 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.seasar.extension.dbcp.impl;

import java.sql.Connection;

import javax.sql.DataSource;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.seasar.extension.jta.TransactionManagerImpl;

/**
 * @author higa
 *
 */
public class DataSourceImplTest {

    /** DataSource */
    private DataSource ds = null;

    /**
     * setUp
     */
    @Before
    public void setUp() {
        final XADataSourceImpl xads = new XADataSourceImpl();
        xads.setDriverClassName("org.postgresql.Driver");
        xads.setURL("jdbc:postgresql://localhost:5432/test");
        xads.setUser("postgres");
        xads.setPassword("postgres");

        final ConnectionPoolImpl pool = new ConnectionPoolImpl();
        pool.setXADataSource(xads);
        pool.setTransactionManager(new TransactionManagerImpl());
        pool.setTimeout(6);
        pool.setMaxPoolSize(1);
        this.ds = new DataSourceImpl(pool);
    }

    /**
     * @throws Exception Exception
     */
    @Test
    public void testGetConnection() throws Exception {
        try (Connection con = this.ds.getConnection()) {
            Assert.assertNotNull("1", con);
        }
    }
}
