/*
 * Copyright 2004-2014 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.seasar.extension.jta.xa;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

/**
 * {@link XAResource}のデフォルト実装です。
 *
 * @author higa
 *
 */
public class DefaultXAResource extends AbstractXAResource {

    /**
     * {@link DefaultXAResource}を作成します。
     */
    public DefaultXAResource() {
        super();
    }

    /**
     * @see org.seasar.extension.jta.xa.AbstractXAResource#doSuccess(javax.transaction.xa.Xid)
     */
    @Override
    protected void doSuccess(final Xid xid) throws XAException {
        return;
    }

    /**
     * @see org.seasar.extension.jta.xa.AbstractXAResource#doFail(javax.transaction.xa.Xid)
     */
    @Override
    protected void doFail(final Xid xid) throws XAException {
        return;
    }

    /**
     * @see org.seasar.extension.jta.xa.AbstractXAResource#doResume(javax.transaction.xa.Xid)
     */
    @Override
    protected void doResume(final Xid xid) throws XAException {
        return;
    }

    /**
     * @see org.seasar.extension.jta.xa.AbstractXAResource#doBegin(javax.transaction.xa.Xid)
     */
    @Override
    protected void doBegin(final Xid xid) throws XAException {
        return;
    }

    /**
     * @see org.seasar.extension.jta.xa.AbstractXAResource#doPrepare(javax.transaction.xa.Xid)
     */
    @Override
    protected int doPrepare(final Xid xid) throws XAException {
        return XA_OK;
    }

    /**
     * @see org.seasar.extension.jta.xa.AbstractXAResource#doRollback(javax.transaction.xa.Xid)
     */
    @Override
    protected void doRollback(final Xid xid) throws XAException {
        return;
    }

    /**
     * @see org.seasar.extension.jta.xa.AbstractXAResource#doSuspend(javax.transaction.xa.Xid)
     */
    @Override
    protected void doSuspend(final Xid xid) throws XAException {
        return;
    }

    /**
     * @see org.seasar.extension.jta.xa.AbstractXAResource#doForget(javax.transaction.xa.Xid)
     */
    @Override
    protected void doForget(final Xid xid) throws XAException {
        return;
    }

    /**
     * @see org.seasar.extension.jta.xa.AbstractXAResource
     * #doCommit(javax.transaction.xa.Xid, boolean)
     */
    @Override
    protected void doCommit(final Xid xid, final boolean onePhase) throws XAException {
        return;
    }
}
