/*
 * $Id: ClassUtils.java 471754 2006-11-06 14:55:09Z husted $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.struts.chain.commands.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <p>Utility methods to load application classes and create instances.</p>
 *
 * @version $Rev: 471754 $ $Date: 2005-11-12 13:01:44 -0500 (Sat, 12 Nov 2005)
 *          $
 */
public final class ClassUtils {

    /** LOGGER */
    private static final Log LOG = LogFactory.getLog(ClassUtils.class);

    /**
     * constructor
     */
    private ClassUtils() {
        throw new AssertionError();
    }

    // ---------------------------------------------------------- Static Methods

    /**
     * <p>Return the <code>Class</code> object for the specified fully
     * qualified class name, from this web application's class loader.
     * @param <T> Type
     * @param className Fully qualified class name
     * @return Class
     */
    public static <T> Class<T> getApplicationClass(final String className) {

        if (className == null) {
            throw new NullPointerException(
                "getApplicationClass called with null className");
        }

        ClassLoader classLoader =
            Thread.currentThread().getContextClassLoader();

        if (classLoader == null) {
            classLoader = ClassUtils.class.getClassLoader();
        }

        try {
            return cast(classLoader.loadClass(className));
        } catch (final ReflectiveOperationException e) {
            LOG.warn(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    /**
     * <p>Return a new instance of the specified fully qualified class name,
     * after loading the class (if necessary) from this web application's
     * class loader.</p>
     * @param <T> Type
     * @param className Fully qualified class name
     * @return Object
     */
    public static <T> T getApplicationInstance(final String className) {
        try {
            return cast(getApplicationClass(className).getDeclaredConstructor().newInstance());
        } catch (final ReflectiveOperationException e) {
            LOG.warn(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    /**
     * cast
     * @param <T> generic
     * @param obj target
     * @return casted
     */
    @SuppressWarnings("unchecked")
    public static <T> T cast(final Object obj) {
        return (T) obj;
    }
}
