/*
 * $Id: ControllerConfig.java 471754 2006-11-06 14:55:09Z husted $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.struts.config;


/**
 * <p>A JavaBean representing the configuration information of a
 * <code>&lt;controller&gt;</code> element in a Struts configuration
 * file.</p>
 *
 * @version $Rev: 471754 $ $Date: 2005-05-12 18:41:19 -0400 (Thu, 12 May 2005)
 *          $
 * @since Struts 1.1
 */
public class ControllerConfig extends BaseConfig {

    /** serialVersionUID */
    private static final long serialVersionUID = 7704474362520651283L;

    // ------------------------------------------------------------- Properties

    /**
     * <p> The input buffer size for file uploads. </p>
     */
    private int bufferSize = 4096;

    /**
     * <p> The content type and character encoding to be set on each response.
     * </p>
     */
    private String contentType = "text/html";

    /**
     * <p> The chain catalog name for this module. </p>
     */
    private String catalog = "struts";

    /**
     * <p> The chain command to execute for each request. </p>
     */
    private String command = "servlet-standard";

    /**
     * <p>The replacement pattern used to determine a context-relative URL
     * from a {@link ForwardConfig} element.  The pattern may consist of any
     * combination of the following markers and characters:</p>
     *
     * <ul>
     *
     * <li><code><strong>$M</strong></code> - Replaced by the module prefix
     * for the current module.</li>
     *
     * <li><code><strong>$P</strong></code> - Replaced by the
     * <code>path</code> property of a {@link ForwardConfig} instance.</li>
     *
     * <li><code><strong>$$</strong></code> - Renders a literal dollar sign
     * ("$") character in the resulting URL.</li>
     *
     * <li>A dollar sign followed by any other character is reserved for
     * future use, and both characters are silently swallowed.</li>
     *
     * <li>All other characters in the pattern are passed through unchanged.
     * </li>
     *
     * </ul>
     *
     * <p>If this property is set to <code>null</code>, a default pattern of
     * <code>$M$P</code> is utilized, which is backwards compatible with the
     * hard coded functionality in prior versions.</p>
     */
    private String forwardPattern = null;

    /**
     * <p>Should the <code>input</code> property of {@link ActionConfig}
     * instances associated with this module be treated as the name of a
     * corresponding {@link ForwardConfig}.  A <code>false</code> value treats
     * them as a module-relative path (consistent with the hard coded behavior
     * of earlier versions of Struts.</p>
     *
     * @since Struts 1.1
     */
    private boolean inputForward = false;

    /**
     * <p> Should we store a Locale object in the user's session if needed?
     * </p>
     */
    private boolean locale = true;

    /**
     * <p> The maximum file size to process for file uploads. </p>
     */
    private String maxFileSize = "250M";

    /**
     * <p> The maximum file size to retain in memory. </p>
     */
    private String memFileSize = "256K";

    /**
     * <p> The fully qualified Java class name of the MultipartRequestHandler
     * class to be used. </p>
     */
    private String multipartClass =
        "org.apache.struts.upload.CommonsMultipartRequestHandler";

    /**
     * <p> Should we set no-cache HTTP headers on each response? </p>
     */
    private boolean nocache = false;

    /**
     * <p>The replacement pattern used to determine a context-relative URL
     * from the <code>page</code> attribute of Struts tags and configuration
     * properties.  The pattern may consist of any combination of the
     * following markers and characters:</p>
     *
     * <ul>
     *
     * <li><code><strong>$M</strong></code> - Replaced by the module prefix
     * for the current module.</li>
     *
     * <li><code><strong>$P</strong></code> - Replaced by the
     * <code>page</code> attribute value being evaluated.</li>
     *
     * <li><code><strong>$$</strong></code> - Renders a literal dollar sign
     * ("$") character in the resulting URL.</li>
     *
     * <li>A dollar sign followed by any other character is reserved for
     * future use, and both characters are silently swallowed.</li>
     *
     * <li>All other characters in the pattern are passed through unchanged.
     * </li>
     *
     * </ul>
     *
     * <p>If this property is set to <code>null</code>, a default pattern of
     * <code>$M$P</code> is utilized, which is backwards compatible with the
     * hard coded functionality in prior versions.</p>
     */
    private String pagePattern = null;

    /**
     * <p> The fully qualified class name of the RequestProcessor
     * implementation class to be used for this module. </p>
     */
    private String processorClass =
        "org.apache.struts.chain.ComposableRequestProcessor";

    /**
     * <p> The temporary working directory to use for file uploads. </p>
     */
    private String tempDir = null;

    /**
     * @return BufferSize
     */
    public int getBufferSize() {
        return this.bufferSize;
    }

    /**
     * @param size BufferSize
     */
    public void setBufferSize(final int size) {
        super.throwIfConfigured();

        this.bufferSize = size;
    }

    /**
     * @return ContentType
     */
    public String getContentType() {
        return this.contentType;
    }

    /**
     * @param val ContentType
     */
    public void setContentType(final String val) {
        super.throwIfConfigured();

        this.contentType = val;
    }

    /**
     * @return Catalog
     */
    public String getCatalog() {
        return this.catalog;
    }

    /**
     * @param val Catalog
     */
    public void setCatalog(final String val) {
        super.throwIfConfigured();

        this.catalog = val;
    }

    /**
     * @return Command
     */
    public String getCommand() {
        return this.command;
    }

    /**
     * @param val Command
     */
    public void setCommand(final String val) {
        super.throwIfConfigured();

        this.command = val;
    }

    /**
     * @return ForwardPattern
     */
    public String getForwardPattern() {
        return this.forwardPattern;
    }

    /**
     * @param pattern ForwardPattern
     */
    public void setForwardPattern(final String pattern) {
        this.forwardPattern = pattern;
    }

    /**
     * @return InputForward
     */
    public boolean getInputForward() {
        return this.inputForward;
    }

    /**
     * @param forward InputForward
     */
    public void setInputForward(final boolean forward) {
        this.inputForward = forward;
    }

    /**
     * @return Locale
     */
    public boolean getLocale() {
        return this.locale;
    }

    /**
     * @param val Locale
     */
    public void setLocale(final boolean val) {
        super.throwIfConfigured();

        this.locale = val;
    }

    /**
     * @return MaxFileSize
     */
    public String getMaxFileSize() {
        return this.maxFileSize;
    }

    /**
     * @param size MaxFileSize
     */
    public void setMaxFileSize(final String size) {
        super.throwIfConfigured();

        this.maxFileSize = size;
    }

    /**
     * @return MemFileSize
     */
    public String getMemFileSize() {
        return this.memFileSize;
    }

    /**
     * @param size MemFileSize
     */
    public void setMemFileSize(final String size) {
        super.throwIfConfigured();

        this.memFileSize = size;
    }

    /**
     * @return MultipartClass
     */
    public String getMultipartClass() {
        return this.multipartClass;
    }

    /**
     * @param multipart MultipartClass
     */
    public void setMultipartClass(final String multipart) {
        super.throwIfConfigured();

        this.multipartClass = multipart;
    }

    /**
     * @return Nocache
     */
    public boolean getNocache() {
        return this.nocache;
    }

    /**
     * @param val Nocache
     */
    public void setNocache(final boolean val) {
        super.throwIfConfigured();

        this.nocache = val;
    }

    /**
     * @return PagePattern
     */
    public String getPagePattern() {
        return this.pagePattern;
    }

    /**
     * @param pattern PagePattern
     */
    public void setPagePattern(final String pattern) {
        this.pagePattern = pattern;
    }

    /**
     * @return ProcessorClass
     */
    public String getProcessorClass() {
        return this.processorClass;
    }

    /**
     * @param processor ProcessClass
     */
    public void setProcessorClass(final String processor) {
        super.throwIfConfigured();

        this.processorClass = processor;
    }

    /**
     * @return TempDir
     */
    public String getTempDir() {
        return this.tempDir;
    }

    /**
     * @param dir TempDir
     */
    public void setTempDir(final String dir) {
        super.throwIfConfigured();

        this.tempDir = dir;
    }

    // --------------------------------------------------------- Public Methods

    /**
     * <p> Return a String representation of this object. </p>
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ControllerConfig[");

        sb.append("bufferSize=");
        sb.append(this.bufferSize);

        if (this.contentType != null) {
            sb.append(",contentType=");
            sb.append(this.contentType);
        }

        if (this.forwardPattern != null) {
            sb.append(",forwardPattern=");
            sb.append(this.forwardPattern);
        }

        sb.append(",inputForward=");
        sb.append(this.inputForward);
        sb.append(",locale=");
        sb.append(this.locale);

        if (this.maxFileSize != null) {
            sb.append(",maxFileSize=");
            sb.append(this.maxFileSize);
        }

        if (this.memFileSize != null) {
            sb.append(",memFileSize=");
            sb.append(this.memFileSize);
        }

        sb.append(",multipartClass=");
        sb.append(this.multipartClass);
        sb.append(",nocache=");
        sb.append(this.nocache);

        if (this.pagePattern != null) {
            sb.append(",pagePattern=");
            sb.append(this.pagePattern);
        }

        sb.append(",processorClass=");
        sb.append(this.processorClass);

        if (this.tempDir != null) {
            sb.append(",tempDir=");
            sb.append(this.tempDir);
        }

        sb.append("]");

        return sb.toString();
    }
}
