/*
 * $Id: TestSetOriginalURI.java 481833 2006-12-03 17:32:52Z niallp $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.struts.chain.commands.servlet;

import java.util.HashMap;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.WebMock;
import org.apache.commons.chain2.Processing;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.chain.contexts.ServletActionContext;
import org.apache.struts.mock.MockServletConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

/**
 * JUnitTest case for class: org.apache.struts.chain.commands.servlet.SetOriginalURI
 */
public class TestSetOriginalURI {

    /** command */
    private SetOriginalURI command = null;

    /**
     * setUp method for test case
     */
    @Before
    public void setUp() {
        this.command = new SetOriginalURI();
    }

    /**
     * testSetOriginalURI
     */
    @Test
    public void testSetOriginalURI() {

        HttpServletRequest request = WebMock.createHttpServletRequest(
                WebMock.createHttpSession(), new HashMap<>(), new HashMap<>());
        Mockito.when(request.getContextPath()).thenReturn("foo/");
        Mockito.when(request.getServletPath()).thenReturn("bar.do");

        MockServletConfig servletConfig = new MockServletConfig();
        ServletContext servletContext = WebMock.createServletContext();

        ActionServlet servlet = Mockito.mock(ActionServlet.class);
        Mockito.when(servlet.getServletContext()).thenReturn(servletContext);
        Mockito.when(servlet.getServletConfig()).thenReturn(servletConfig);
        Mockito.when(servlet.getInternal()).thenCallRealMethod();

        HttpServletResponse response = Mockito.mock(HttpServletResponse.class);

        ServletActionContext saContext = new ServletActionContext(
                servletContext, request, response);

        saContext.setActionServlet(servlet);

        Processing result = this.command.execute(saContext);
        Assert.assertEquals(Processing.CONTINUE, result);

        String uri = (String) request.getAttribute(Globals.ORIGINAL_URI_KEY);
        Assert.assertEquals("Original uri not correct: " + uri, "bar.do", uri);

        Mockito.when(request.getContextPath()).thenReturn("foo/");
        Mockito.when(request.getServletPath()).thenReturn("bar2.do");
        uri = (String) request.getAttribute(Globals.ORIGINAL_URI_KEY);
        Assert.assertEquals("Original uri not correct: " + uri, "bar.do", uri);
    }
}
