/*
 * $Id: TestRequestUtilsPopulate.java 471754 2006-11-06 14:55:09Z husted $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.struts.util;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

import org.apache.WebMock;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.chain.contexts.ServletActionContext;
import org.apache.struts.mock.MockFormBean;
import org.apache.struts.mock.MockMultipartRequestHandler;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

/**
 * Unit tests for the RequestUtil's <code>populate</code> method.
 *
 * @version $Rev: 471754 $
 */
public class TestRequestUtilsPopulate {

    /**
     * Ensure that the getMultipartRequestHandler cannot be seen in
     * a subclass of ActionForm.
     *
     * The purpose of this test is to ensure that Bug #38534 is fixed.
     */
    @Test
    public void testMultipartVisibility() {

        String mockMappingName = "mockMapping";

        ActionMapping mapping = new ActionMapping();
        mapping.setName(mockMappingName);

        // Set up the mock HttpServletRequest
        Map<String, String[]> pMap = new HashMap<>();
        pMap.put("stringProperty", new String[]{"Test"});
        pMap.put("multipartRequestHandler.mapping.name", new String[]{"Bad"});

        HttpServletRequest request = WebMock.createHttpServletRequest(
                WebMock.createHttpSession(), new HashMap<>(), pMap);
        Mockito.when(request.getMethod()).thenReturn("POST");
        Mockito.when(request.getContentType()).thenReturn("multipart/form-data");
        request.setAttribute(Globals.MULTIPART_KEY,
                MockMultipartRequestHandler.class.getName());
        request.setAttribute(Globals.MAPPING_KEY, mapping);

        MockFormBean mockForm = new MockFormBean();
        // Check the Mapping/ActionForm before
        Assert.assertNull("Multipart Handler already set", mockForm.getMultipartRequestHandler());
        Assert.assertEquals("Mapping name not set correctly", mockMappingName, mapping.getName());

        ServletContext servletContext = WebMock.createServletContext();

        ServletActionContext ctx = new ServletActionContext(servletContext, request, null);

        RequestUtils.populate(mockForm, ctx);

        // Check the Mapping/ActionForm after
        Assert.assertNotNull("Multipart Handler Missing", mockForm.getMultipartRequestHandler());
        Assert.assertEquals("Mapping name has been modified", mockMappingName, mapping.getName());

    }

}
