package core.util.bean;

import java.util.function.Supplier;

/**
 * Deal
 *
 * @author Tadashi Nakayama
 */
public final class Deal {

	/** 条件結果 */
	private Boolean bool;

	/**
	 * コンストラクタ
	 *
	 * @param b 初期条件
	 */
	private Deal(final boolean b) {
		this.bool = b;
	}

	/**
	 * 条件が true の場合 actionを呼び出す。
	 *
	 * @param action Runnable
	 * @return Deal
	 */
	public Deal then(final Runnable action) {
		if (this.bool) {
			action.run();
		}
		return this;
	}

	/**
	 * 条件が true の場合 action を呼出し、結果を条件に保存する。
	 *
	 * @param action Supplier
	 * @return Deal
	 */
	public Deal then(final Supplier<Boolean> action) {
		if (this.bool) {
			this.bool = action.get();
		}
		return this;
	}

	/**
	 * 結果取得
	 *
	 * @return 結果
	 */
	public boolean result() {
		return this.bool;
	}

	/**
	 * ファクトリメソッド
	 *
	 * @param bool 初期条件
	 * @return Deal
	 */
	public static Deal of(final boolean bool) {
		return new Deal(bool);
	}
}
