package core.util.bean;

import java.io.Serializable;

/**
 * Pair
 *
 * @author Tadashi Nakayama
 * @param <L> 左要素ジェネリクス
 * @param <R> 右要素ジェネリクス
 */
public class Pair<L, R> implements Serializable {
	/** serialVersionUID */
	private static final long serialVersionUID = 1L;

	/** 左要素 */
	private final L left;
	/** 右要素 */
	private final R right;

	/**
	 * コンストラクタ
	 *
	 * @param l 左要素
	 * @param r 右要素
	 */
	public Pair(final L l, final R r) {
		this.left = l;
		this.right = r;
	}

	/**
	 * 左要素存在取得
	 *
	 * @return 左要素
	 */
	public L left() {
		return this.left;
	}

	/**
	 * 右要素取得
	 *
	 * @return 右要素
	 */
	public R right() {
		return this.right;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return this.left + ":" + this.right;
	}

	/**
	 * ファクトリメソッド
	 *
	 * @param <L> 左要素ジェネリクス
	 * @param <R> 右要素ジェネリクス
	 * @param left 左要素
	 * @param right 右要素
	 * @return Pair
	 */
	public static <L, R> Pair<L, R> of(final L left, final R right) {
		return new Pair<>(left, right);
	}
}
