package project.db.model;

import java.util.Date;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * FwJobDetail generated by hbm2java
 */
@org.hibernate.annotations.DynamicInsert
@Entity
@Table(name = "fw_job_detail")
public class FwJobDetail implements java.io.Serializable {

	private FwJobDetailId id;
	private String batName;
	private int pid;
	private int status;
	private Date startDateTime;
	private Date stopDateTime;
	private String message;

	public FwJobDetail() {
	}

	public FwJobDetail(FwJobDetailId id, String batName, int pid, int status,
			Date startDateTime) {
		this.id = id;
		this.batName = batName;
		this.pid = pid;
		this.status = status;
		this.startDateTime = startDateTime;
	}

	public FwJobDetail(FwJobDetailId id, String batName, int pid, int status,
			Date startDateTime, Date stopDateTime, String message) {
		this.id = id;
		this.batName = batName;
		this.pid = pid;
		this.status = status;
		this.startDateTime = startDateTime;
		this.stopDateTime = stopDateTime;
		this.message = message;
	}

	@EmbeddedId
	@AttributeOverrides({
			@AttributeOverride(name = "jobSeq", column = @Column(name = "job_seq", nullable = false)),
			@AttributeOverride(name = "batSeq", column = @Column(name = "bat_seq", nullable = false)) })
	public FwJobDetailId getId() {
		return this.id;
	}

	public void setId(FwJobDetailId id) {
		this.id = id;
	}

	@Column(name = "bat_name", nullable = false, length = 128)
	public String getBatName() {
		return this.batName;
	}

	public void setBatName(String batName) {
		this.batName = batName;
	}

	@Column(name = "pid", nullable = false)
	public int getPid() {
		return this.pid;
	}

	public void setPid(int pid) {
		this.pid = pid;
	}

	@Column(name = "status", nullable = false)
	public int getStatus() {
		return this.status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "start_date_time", nullable = false, length = 29)
	public Date getStartDateTime() {
		return this.startDateTime;
	}

	public void setStartDateTime(Date startDateTime) {
		this.startDateTime = startDateTime;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "stop_date_time", length = 29)
	public Date getStopDateTime() {
		return this.stopDateTime;
	}

	public void setStopDateTime(Date stopDateTime) {
		this.stopDateTime = stopDateTime;
	}

	@Column(name = "message", length = 512)
	public String getMessage() {
		return this.message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

}
