CREATE TABLE FW_JOB_DETAIL
(
  JOB_SEQ             BIGINT        NOT NULL,
  BAT_SEQ             SMALLINT      NOT NULL,
  BAT_NAME            VARCHAR(128)  NOT NULL,
  PID                 INTEGER       NOT NULL,
  STATUS              SMALLINT      NOT NULL,
  START_DATE_TIME     TIMESTAMP     NOT NULL,
  STOP_DATE_TIME      TIMESTAMP,
  MESSAGE             VARCHAR(512),
  CONSTRAINT FW_JOB_DETAIL_PK PRIMARY KEY (JOB_SEQ, BAT_SEQ)
)
;


COMMENT ON TABLE FW_JOB_DETAIL IS 'バッチ管理';
COMMENT ON COLUMN FW_JOB_DETAIL.JOB_SEQ IS 'ジョブ連番';
COMMENT ON COLUMN FW_JOB_DETAIL.BAT_SEQ IS 'バッチ連番';
COMMENT ON COLUMN FW_JOB_DETAIL.BAT_NAME IS 'バッチ名';
COMMENT ON COLUMN FW_JOB_DETAIL.PID IS 'プロセスID';
COMMENT ON COLUMN FW_JOB_DETAIL.STATUS IS 'ステータス';
COMMENT ON COLUMN FW_JOB_DETAIL.START_DATE_TIME IS '実行開始日時';
COMMENT ON COLUMN FW_JOB_DETAIL.STOP_DATE_TIME IS '実行終了日時';
COMMENT ON COLUMN FW_JOB_DETAIL.MESSAGE IS 'メッセージ';
