package project.check.existence;

import java.util.Optional;

import core.util.bean.Pair;
import online.context.check.ItemCheck;
import project.check.BaseCheck;
import project.master.MsgUtil;

/**
 * 項目長等価チェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class EquivalentCheck extends BaseCheck implements ItemCheck {

	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 */
	public EquivalentCheck() {
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public EquivalentCheck(final String msgId, final String... param) {
		this.mid = msgId;
		this.prm = copyOf(param);
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {
		Optional<Pair<String, Integer>> check = Optional.empty();
		var length = -1;
		for (final var item : items) {
			final var val = getArrayParameter(item);
			if (length == -1) {
				length = 0;
				if (val != null) {
					length = val.length;
				}
			} else if (val == null || length != val.length) {
				if (!MsgUtil.hasItemMessage(getUniModel(), item)) {
					addTopMessage(this.mid, this.prm);
					MsgUtil.putMessage(getUniModel(), item, this.mid, this.prm);
				}
				check = Optional.of(check.orElse(Pair.of(item, 0)));
			}
		}

		check.ifPresent(this::throwNoMoreCheckException);
	}
}
