package project.check.existence;

import java.util.Optional;

import core.util.bean.Pair;
import online.context.check.ItemCheck;
import online.model.ModelUtil;
import project.check.BaseCheck;
import project.common.CheckUtil;
import project.master.MsgUtil;

/**
 * 空白空文字チェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class NotEmptyCheck extends BaseCheck implements ItemCheck {

	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 */
	public NotEmptyCheck() {
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public NotEmptyCheck(final String msgId, final String... param) {
		this.mid = msgId;
		this.prm = copyOf(param);
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {
		Optional<Pair<String, Integer>> check = Optional.empty();
		for (final var item : items) {
			final var val = getArrayParameter(item);
			if (val == null || val.length == 0) {
				if (!MsgUtil.hasItemMessage(getUniModel(), item)) {
					addTopMessage(this.mid, this.prm);
					MsgUtil.putMessage(getUniModel(), item, this.mid, this.prm);
				}
				check = Optional.of(check.orElse(Pair.of(item, 0)));
				continue;
			}

			for (var j = 0; j < val.length; j++) {
				if (!isTarget(j)) {
					val[j] = ModelUtil.getValueAsString(getUniModel(), item, j);
				} else if (CheckUtil.isZenTrimEmpty(val[j])) {
					setMessage(item, j, this.mid, this.prm);
					check = Optional.of(check.orElse(Pair.of(item, j)));
				}
			}
		}

		check.ifPresent(this::throwKeepCheckException);
	}
}
