package online.struts.chain.processor;

import org.apache.commons.chain2.Command;
import org.apache.commons.chain2.Context;
import org.apache.struts.chain.commands.ExecuteForwardCommand;
import org.apache.struts.chain.contexts.ActionContext;

/**
 * フォワードコマンド
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public class ExecuteCommandProcessor extends ExecuteForwardCommand {

	/** カタログ */
	private String catalog;
	/** コマンド */
	private String command;

	/**
	 * コマンド取得
	 *
	 * @param context コンテキスト
	 * @return コマンド
	 */
	@Override
	protected Command<String, Object, Context<String, Object>> getCommand(
			final ActionContext<String, Object> context) {
		return super.getCommand(this.command, this.catalog);
	}

	/**
	 * カタログ取得
	 *
	 * @return カタログ
	 */
	public String getCatalog() {
		return this.catalog;
	}

	/**
	 * カタログ設定
	 *
	 * @param val カタログ
	 */
	public void setCatalog(final String val) {
		this.catalog = val;
	}

	/**
	 * コマンド取得
	 *
	 * @return コマンド
	 */
	public String getCommand() {
		return this.command;
	}

	/**
	 * コマンド設定
	 *
	 * @param val コマンド
	 */
	public void setCommand(final String val) {
		this.command = val;
	}
}
